/*
 * Decompiled with CFR 0.152.
 */
package stallone.graph.connectivity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import stallone.api.graph.IIntConnectivity;
import stallone.api.graph.IIntGraph;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntIterator;
import stallone.api.ints.Ints;
import stallone.doubles.fastutils.IntAVLTreeSet;
import stallone.doubles.fastutils.IntSortedSet;

public class IntStrongConnectivity
implements IIntConnectivity {
    private IIntGraph graph;
    private HashMap<Integer, IntVertexInfo> vertex2info = new HashMap();
    private List<IntSortedSet> internalComponents;
    private List<IIntArray> components;
    private int index;
    private Stack<IntVertexInfo> S;

    public IntStrongConnectivity(IIntGraph graph) {
        this.setGraph(graph);
    }

    @Override
    public final void setGraph(IIntGraph graph) {
        this.graph = graph;
        IIntIterator it = graph.nodeIterator();
        while (it.hasNext()) {
            IntVertexInfo ivi = new IntVertexInfo(it.get());
            this.vertex2info.put(it.get(), ivi);
            it.advance();
        }
        this.internalComponents = new ArrayList<IntSortedSet>();
        this.components = new ArrayList<IIntArray>();
        this.index = 0;
        this.S = new Stack();
    }

    @Override
    public void perform() {
        ArrayList<IntVertexInfo> tmp = new ArrayList<IntVertexInfo>(this.vertex2info.values());
        int i = 0;
        while (i < tmp.size()) {
            if (((IntVertexInfo)tmp.get(i)).notNumbered()) {
                this.perform(((IntVertexInfo)tmp.get((int)i)).node);
            }
            ++i;
        }
        for (IntSortedSet iss : this.internalComponents) {
            this.components.add(Ints.create.arrayFrom(iss.toArray(new int[iss.size()])));
        }
    }

    private void perform(int n) {
        this.tarjan(this.vertex2info.get(n));
    }

    private void tarjan(IntVertexInfo v) {
        v.index = this.index;
        v.lowlink = this.index++;
        this.S.push(v);
        IIntIterator it = this.graph.neighborIterator(v.node);
        while (it.hasNext()) {
            int node = it.get();
            IntVertexInfo vp = this.vertex2info.get(node);
            if (vp.index == -1) {
                this.tarjan(vp);
                v.lowlink = Math.min(v.lowlink, vp.lowlink);
            } else if (this.S.contains(vp)) {
                v.lowlink = Math.min(v.lowlink, vp.index);
            }
            it.advance();
        }
        if (v.lowlink == v.index) {
            IntVertexInfo j;
            IntAVLTreeSet component = new IntAVLTreeSet();
            do {
                j = this.S.pop();
                component.add(j.node);
            } while (j != v);
            this.internalComponents.add(component);
        }
    }

    @Override
    public List<IIntArray> getStrongComponents() {
        return this.components;
    }

    public class IntVertexInfo {
        public int node;
        public int index = -1;
        public int lowlink = -1;

        public IntVertexInfo(int n) {
            this.node = n;
        }

        public boolean notNumbered() {
            return this.index == -1;
        }

        public String toString() {
            return "vertex [index=" + this.index + ", lowlink=" + this.lowlink + ", node=" + this.node + "]";
        }
    }
}

