/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm.pmm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import stallone.api.API;
import stallone.api.cluster.IClustering;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataSequenceLoader;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.hmm.pmm.MultiClustering;
import stallone.util.CommandLineParser;

public class MultiClusteringKmeans {
    private List<String> inputFiles;
    private IDataInput data;
    private int nclusters;
    private int nsplit;
    private String outPrefix;
    private MultiClustering mc;

    public boolean parseArguments(String[] args) throws FileNotFoundException, IOException {
        CommandLineParser parser = new CommandLineParser();
        parser.addStringArrayCommand("i", true);
        parser.addIntCommand("ncluster", true);
        parser.addIntCommand("nsplit", true);
        parser.addStringCommand("o", true);
        if (!parser.parse(args)) {
            return false;
        }
        String[] ifiles = parser.getStringArray("i");
        this.inputFiles = new ArrayList<String>();
        int i = 0;
        while (i < ifiles.length) {
            this.inputFiles.add(ifiles[i]);
            ++i;
        }
        IDataSequenceLoader loader = API.dataNew.multiSequenceLoader(this.inputFiles);
        this.data = loader.loadAll();
        this.nclusters = parser.getInt("ncluster");
        this.nsplit = parser.getInt("nsplit");
        this.outPrefix = parser.getString("o");
        return true;
    }

    public static String getUsageString() {
        return "\n=======================================\n MultiClusteringKmeans\n=======================================\nUsage: \nMandatory input and output options:  -i  <discrete trajectory>+\n -ncluster <number of initial clusters>\n -nsplit <number of new clusters per split>\n\n -o <out-prefix>\n";
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        MultiClusteringKmeans cmd;
        if (args.length == 0) {
            System.out.println(MultiClusteringKmeans.getUsageString());
            System.exit(0);
        }
        if (!(cmd = new MultiClusteringKmeans()).parseArguments(args)) {
            System.out.println(MultiClusteringKmeans.getUsageString());
            System.exit(0);
        }
        IClustering clustering1 = API.clusterNew.kmeans(cmd.nclusters, 10);
        IClustering clustering2 = API.clusterNew.kmeans(cmd.nsplit, 10);
        cmd.mc = new MultiClustering(cmd.data.getSequence(0), clustering1, clustering2);
        cmd.mc.split(0);
        cmd.mc.split(0);
        cmd.mc.split(0);
        cmd.mc.split(0);
        cmd.mc.split(0);
        cmd.mc.split(0);
        ArrayList<IIntArray> leaves = cmd.mc.getLeafIndexes();
        PrintStream[] out = new PrintStream[leaves.size()];
        int i = 0;
        while (i < out.length) {
            out[i] = new PrintStream(String.valueOf(cmd.outPrefix) + "_cluster-" + (i + 1) + ".dat");
            IIntArray leaf = leaves.get(i);
            System.out.println("leaf size = " + leaf.size());
            int j = 0;
            while (j < leaf.size()) {
                IDoubleArray data = cmd.data.getSequence(0).get(leaf.get(j));
                out[i].println(data.get(0));
                ++j;
            }
            out[i].close();
            ++i;
        }
    }
}

