/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm.pmm;

import stallone.api.API;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.IDoubleArray;
import stallone.mc.pcca.PCCA;

public class NinjaUtilities {
    public static IDoubleArray tuneMetastability(IDoubleArray T, double timescaleFactor) {
        IDoubleArray Tnew = T.copy();
        int i = 0;
        while (i < Tnew.rows()) {
            Tnew.set(i, i, Math.pow(Tnew.get(i, i), 1.0 / timescaleFactor));
            double cOffdiag = (1.0 - Tnew.get(i, i)) / (API.alg.sum(Tnew.viewRow(i)) - Tnew.get(i, i));
            int j = 0;
            while (j < Tnew.columns()) {
                if (j != i) {
                    Tnew.set(i, j, cOffdiag * Tnew.get(i, j));
                }
                ++j;
            }
            ++i;
        }
        return Tnew;
    }

    public static void main(String[] args) {
        IDoubleArray T = API.doublesNew.array(new double[][]{{0.8, 0.2, 0.0, 0.0}, {0.2, 0.75, 0.05, 0.0}, {0.0, 0.05, 0.75, 0.2}, {0.0, 0.0, 0.2, 0.8}});
        IDoubleArray ts1 = API.msm.timescales(T, 1.0);
        IEigenvalueDecomposition evd = API.alg.evd(T);
        IComplexArray Lambda = evd.getDiagonalMatrix();
        System.out.println("old timescales: " + ts1);
        System.out.println("Lambda = \n" + Lambda + "\n");
        int nhidden = 2;
        PCCA pcca = API.msmNew.createPCCA(T, nhidden);
        IDoubleArray R = evd.getRightEigenvectorMatrix().viewReal();
        IDoubleArray Rsub = R.viewBlock(0, 0, T.rows(), nhidden);
        pcca.setEigenvectors(Rsub);
        pcca.perform();
        IDoubleArray M = pcca.getFuzzy();
        System.out.println("M\n" + M);
        IDoubleArray pi = API.msm.stationaryDistribution(T);
        IDoubleArray Pi = API.doublesNew.diag(pi);
        IDoubleArray piC = API.alg.product(API.alg.transposeToNew(M), pi);
        IDoubleArray PiC = API.doublesNew.diag(piC);
        System.out.println("Pi = \n" + Pi + "\n");
        System.out.println("PiC = \n" + PiC + "\n");
        IDoubleArray Res = API.alg.transposeToNew(M);
        IDoubleArray Int = API.alg.product(API.alg.product(Pi, M), API.alg.inverse(PiC));
        System.out.println("R = \n" + Res + "\n");
        System.out.println("I = \n" + Int + "\n");
        IDoubleArray RItinv = API.alg.transposeToNew(API.alg.inverse(API.alg.product(Res, Int)));
        IDoubleArray IntT = API.alg.transposeToNew(Int);
        IDoubleArray ResT = API.alg.transposeToNew(Res);
        IDoubleArray TC = API.alg.product(API.alg.product(API.alg.product(RItinv, IntT), T), ResT);
        System.out.println("TC = \n" + TC + "\n");
        IEigenvalueDecomposition evdC = API.alg.evd(TC);
        IComplexArray LambdaC = evdC.getDiagonalMatrix();
        System.out.println("LambdaC = \n" + LambdaC + "\n");
        System.exit(0);
    }
}

