/*
 * Decompiled with CFR 0.152.
 */
package stallone.ints;

import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntIterator;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;
import stallone.doubles.fastutils.IntArrayList;
import stallone.ints.IntArrayIterator;
import stallone.ints.IntArrayNonzeroIterator;
import stallone.ints.IntArrayView;

public class IntArrayList_FastUtilWrapper
implements IIntList {
    private IntArrayList list;

    private IntArrayList_FastUtilWrapper(IntArrayList _list) {
        this.list = _list;
    }

    public IntArrayList_FastUtilWrapper() {
        this.list = new IntArrayList();
    }

    public IntArrayList_FastUtilWrapper(int capacity) {
        this.list = new IntArrayList(capacity);
    }

    public IntArrayList_FastUtilWrapper(int[] a) {
        this.list = new IntArrayList(a);
    }

    @Override
    public void append(int value) {
        this.list.add(value);
    }

    @Override
    public void appendAll(IIntArray values) {
        int i = 0;
        while (i < values.size()) {
            this.list.add(values.get(i));
            ++i;
        }
    }

    @Override
    public void insert(int index, int value) {
        this.list.add(index, value);
    }

    @Override
    public void insertAll(int index, IIntArray values) {
        int i = 0;
        while (i < values.size()) {
            this.list.add(index + i, values.get(i));
            ++i;
        }
    }

    @Override
    public void remove(int index) {
        this.list.remove(index);
    }

    @Override
    public void removeRange(int from, int to) {
        int i = from;
        while (i < to) {
            this.list.remove(from);
            ++i;
        }
    }

    @Override
    public void removeByValue(int value) {
        this.list.rem(value);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public int get(int i) {
        return this.list.get(i);
    }

    @Override
    public void set(int i, int v) {
        this.list.set(i, v);
    }

    @Override
    public void copyFrom(IIntArray other) {
        this.list.ensureCapacity(other.size());
        int i = 0;
        while (i < other.size()) {
            this.list.set(i, other.get(i));
            ++i;
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public IIntList copy() {
        return new IntArrayList_FastUtilWrapper(this.list.clone());
    }

    @Override
    public IIntArray create(int size) {
        return new IntArrayList_FastUtilWrapper(size);
    }

    @Override
    public int[] getArray() {
        return this.list.toIntArray();
    }

    @Override
    public IIntIterator iterator() {
        return new IntArrayIterator(this);
    }

    public String toString() {
        return Ints.util.toString(this);
    }

    @Override
    public int order() {
        return 1;
    }

    @Override
    public int rows() {
        return this.size();
    }

    @Override
    public int columns() {
        return 1;
    }

    @Override
    public int get(int i, int j) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a list. Column index " + j + " does not exist!");
        }
        return this.get(i);
    }

    @Override
    public void set(int i, int j, int x) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a list. Column index " + j + " does not exist!");
        }
        this.set(i, x);
    }

    @Override
    public int[][] getTable() {
        int[][] res = new int[this.size()][1];
        int i = 0;
        while (i < res.length) {
            res[i][0] = this.get(i);
            ++i;
        }
        return res;
    }

    @Override
    public int[] getRow(int i) {
        return new int[]{this.get(i)};
    }

    @Override
    public int[] getColumn(int j) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a list. Column index " + j + " does not exist!");
        }
        return this.getArray();
    }

    @Override
    public IIntIterator nonzeroIterator() {
        return new IntArrayNonzeroIterator(this);
    }

    @Override
    public void copyInto(IIntArray other) {
        if (other.size() != this.size()) {
            throw new IllegalArgumentException("Incompatible sizes. This array has size " + this.size() + ", the other array has size " + other.size());
        }
        Ints.util.copyInto(this, 0, this.size(), other, 0);
    }

    @Override
    public IIntArray create(int rows, int columns) {
        if (columns > 1) {
            throw new IllegalArgumentException("Cannot create a list with more than one column");
        }
        return new IntArrayList_FastUtilWrapper(rows);
    }

    @Override
    public IIntArray viewRow(int i) {
        return new IntArrayView(this, i, 0, i + 1, 1);
    }

    @Override
    public IIntArray viewColumn(int j) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a column array. Column index " + j + " does not exist!");
        }
        return this;
    }

    @Override
    public boolean isSparse() {
        return false;
    }
}

