/*
 * Decompiled with CFR 0.152.
 */
package stallone.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import stallone.api.io.IReleasableFile;

public class CachedRandomAccessFile
implements IReleasableFile {
    protected String filename;
    protected byte[] page;
    protected ByteBuffer pageBuffer;
    protected int pageSize;
    protected long currentPos;
    protected long pageStart;
    protected long pageEnd;
    protected RandomAccessFile randomAccessFile;
    protected long filesize;

    public CachedRandomAccessFile(String _filename) throws FileNotFoundException, IOException {
        this(_filename, 8192);
    }

    public CachedRandomAccessFile(String _filename, int pageSize) throws FileNotFoundException, IOException {
        if (pageSize % 8 != 0) {
            throw new RuntimeException("Pagesize must be dividable by 8.");
        }
        this.filename = _filename;
        this.randomAccessFile = new RandomAccessFile(_filename, "r");
        this.page = new byte[pageSize];
        this.pageSize = pageSize;
        this.filesize = this.randomAccessFile.length();
        this.updatePosition(0L);
        this.pageStart = 0L;
        this.pageEnd = -1L;
    }

    private void updatePosition(long pos) throws IOException {
        this.currentPos = pos;
    }

    protected int makePageAvailable() throws IOException {
        if (this.currentPos < this.pageStart || this.currentPos >= this.pageEnd) {
            if (this.currentPos >= this.filesize) {
                throw new IOException("Invalid position");
            }
            this.pageStart = this.currentPos / (long)this.pageSize * (long)this.pageSize;
            this.pageEnd = this.pageStart + (long)this.pageSize;
            if (this.pageEnd > this.filesize) {
                this.pageEnd = this.filesize;
            }
            this.randomAccessFile.seek(this.pageStart);
            int le = (int)(this.pageEnd - this.pageStart);
            this.randomAccessFile.readFully(this.page, 0, le);
            this.pageBuffer = ByteBuffer.wrap(this.page, 0, le);
        }
        this.pageBuffer.position((int)(this.currentPos - this.pageStart));
        return (int)(this.pageEnd - this.currentPos);
    }

    public void seek(long pos) throws IOException {
        this.updatePosition(pos);
    }

    public int skipBytes(int n) throws IOException {
        if (this.currentPos + (long)n > this.filesize) {
            int diff = (int)(this.filesize - this.currentPos);
            this.updatePosition(this.filesize);
            return diff;
        }
        this.updatePosition(this.currentPos + (long)n);
        return n;
    }

    public int read() throws IOException {
        if (this.currentPos < this.filesize) {
            this.makePageAvailable();
            byte ret = this.pageBuffer.get();
            this.updatePosition((long)this.pageBuffer.position() + this.pageStart);
            return ret;
        }
        return -1;
    }

    public int readInt() throws IOException {
        this.makePageAvailable();
        int value = this.pageBuffer.getInt();
        this.updatePosition((long)this.pageBuffer.position() + this.pageStart);
        return value;
    }

    public float readFloat() throws IOException {
        this.makePageAvailable();
        float value = this.pageBuffer.getFloat();
        this.updatePosition((long)this.pageBuffer.position() + this.pageStart);
        return value;
    }

    public long length() throws IOException {
        return this.randomAccessFile.length();
    }

    public long getFilePointer() {
        return this.currentPos;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public void open() throws IOException {
        this.randomAccessFile = new RandomAccessFile(this.filename, "r");
    }

    public void readFully(byte[] b, int size) throws IOException {
        int requestedSize = size <= 0 ? b.length : size;
        int alreadyRead = 0;
        while (alreadyRead < requestedSize) {
            int left = requestedSize - alreadyRead;
            int bytesLeftInThisPage = this.makePageAvailable();
            if (left <= bytesLeftInThisPage) {
                this.pageBuffer.get(b, alreadyRead, left);
                alreadyRead += left;
            } else {
                this.pageBuffer.get(b, alreadyRead, bytesLeftInThisPage);
                alreadyRead += bytesLeftInThisPage;
            }
            this.updatePosition((long)this.pageBuffer.position() + this.pageStart);
        }
    }

    public final String readLine() throws IOException {
        StringBuilder input = new StringBuilder();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public String getFileName() {
        return this.filename;
    }
}

