/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc;

import stallone.api.algebra.Algebra;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.AbstractDoubleArray;
import stallone.mc.PosteriorCountMatrixIterator;

public class PosteriorCountMatrix
extends AbstractDoubleArray {
    private IDoubleArray prior;
    private IDoubleArray obs;

    public PosteriorCountMatrix(IDoubleArray _prior, IDoubleArray _obs) {
        this.prior = _prior;
        this.obs = _obs;
    }

    @Override
    public double get(int i, int j) {
        return this.prior.get(i, j) + this.obs.get(i, j);
    }

    @Override
    public int rows() {
        return this.obs.rows();
    }

    @Override
    public int columns() {
        return this.obs.columns();
    }

    @Override
    public void set(int i, int j, double value) {
        this.obs.set(i, j, value);
    }

    @Override
    public void copyFrom(IDoubleArray other) {
        int _size = other.size();
        if (_size != this.size()) {
            throw new IllegalArgumentException("Trying to copy from array with different size");
        }
        int i = 0;
        while (i < _size) {
            this.set(i, other.get(i));
            ++i;
        }
    }

    public void setPrior(IDoubleArray _prior) {
        this.prior = _prior;
    }

    public void setObservation(IDoubleArray _obs) {
        this.obs = _obs;
    }

    @Override
    public void zero() {
        this.obs.zero();
    }

    @Override
    public IDoubleArray copy() {
        return new PosteriorCountMatrix(this.prior.copy(), this.obs.copy());
    }

    @Override
    public void copyInto(IDoubleArray target) {
        target.zero();
        IDoubleIterator it = this.nonzeroIterator();
        while (it.hasNext()) {
            target.set(it.row(), it.column(), it.get());
            it.advance();
        }
    }

    @Override
    public IDoubleArray create(int rows, int cols) {
        return new PosteriorCountMatrix(this.prior.create(rows, cols), this.obs.create(rows, cols));
    }

    @Override
    public IDoubleArray create(int size) {
        throw new UnsupportedOperationException("Linear create not supported for matrix.");
    }

    @Override
    public IDoubleIterator iterator() {
        IDoubleArray sum = Algebra.util.add(this.prior, this.obs);
        IDoubleIterator itElements = sum.iterator();
        return new PosteriorCountMatrixIterator(this, itElements);
    }

    @Override
    public IDoubleIterator nonzeroIterator() {
        IDoubleArray sum = Algebra.util.add(this.prior, this.obs);
        IDoubleIterator itElements = sum.nonzeroIterator();
        return new PosteriorCountMatrixIterator(this, itElements);
    }

    @Override
    public double[][] getTable() {
        double[][] res = this.prior.getTable();
        IDoubleIterator it = this.obs.nonzeroIterator();
        while (it.hasNext()) {
            double[] dArray = res[it.row()];
            int n = it.column();
            dArray[n] = dArray[n] + it.get();
            it.advance();
        }
        return res;
    }

    @Override
    public boolean isSparse() {
        return this.prior.isSparse() && this.obs.isSparse();
    }
}

