/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc;

import java.io.FileNotFoundException;
import java.io.IOException;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;

public class TransitionMatrixSplitter {
    private IDoubleArray T_old;

    public TransitionMatrixSplitter(IDoubleArray _Ta) {
        this.T_old = _Ta;
    }

    public IDoubleArray splitForLifetimes(int state, double p1, double k1, double k2) {
        IDoubleArray pi_old = API.msm.stationaryDistribution(this.T_old);
        IDoubleArray Pi_old = API.doublesNew.diag(pi_old);
        IDoubleArray C_old = API.alg.product(Pi_old, this.T_old);
        int n = this.T_old.rows();
        double pi_state_old = pi_old.get(state);
        IDoubleArray C_split = API.doublesNew.matrix(n + 1, n + 1);
        IDoubleArray pi_split = API.doublesNew.array(n + 1);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (i != state && j != state) {
                    C_split.set(i, j, C_old.get(i, j));
                    pi_split.set(i, pi_old.get(i));
                }
                ++j;
            }
            ++i;
        }
        double pi_split_1 = p1 * pi_old.get(state);
        double pi_split_2 = pi_old.get(state) - pi_split_1;
        pi_split.set(state, pi_split_1);
        pi_split.set(n, pi_split_2);
        double d1 = pi_split_1 * Math.exp(-k1);
        double d2 = pi_split_2 * Math.exp(-k2);
        C_split.set(state, state, d1);
        C_split.set(n, n, d2);
        double split_block_trans = 0.5 * (C_old.get(state, state) - d1 - d2);
        if (split_block_trans < 0.0 || split_block_trans > Math.min(pi_split_1 - d1, pi_split_2 - d2)) {
            split_block_trans = Math.min(pi_split_1 - d1, pi_split_2 - d2) / (double)(10 * n + 1);
        }
        C_split.set(state, n, split_block_trans);
        C_split.set(n, state, split_block_trans);
        double sum_old = pi_state_old - C_old.get(state, state);
        double rest1 = pi_split_1 - d1 - split_block_trans;
        double rest2 = pi_split_2 - d2 - split_block_trans;
        int i2 = 0;
        while (i2 < n) {
            if (i2 != state) {
                C_split.set(state, i2, rest1 * C_old.get(state, i2) / sum_old);
                C_split.set(i2, state, C_split.get(state, i2));
                C_split.set(n, i2, rest2 * C_old.get(state, i2) / sum_old);
                C_split.set(i2, n, C_split.get(n, i2));
            }
            ++i2;
        }
        IDoubleArray T_split = C_split.copy();
        API.alg.normalizeRows(T_split, 1);
        IDoubleArray pi_res = API.msm.stationaryDistribution(T_split);
        double err = API.alg.distance(pi_res, pi_split);
        double p1_res = pi_res.get(state) / (pi_res.get(state) + pi_res.get(n));
        double k1_res = -Math.log(T_split.get(state, state));
        double k2_res = -Math.log(T_split.get(n, n));
        return T_split;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length == 0) {
            System.out.println("Usage: TransitionMatrixSplitter <T-matrix> <split-state> <p1> <k1> <k2>");
        }
        IDoubleArray T_old = API.doublesNew.fromFile(args[0]);
        int split_state = API.str.toInt(args[1]);
        double p1 = API.str.toDouble(args[2]);
        double k1 = API.str.toDouble(args[3]);
        double k2 = API.str.toDouble(args[4]);
        TransitionMatrixSplitter tms = new TransitionMatrixSplitter(T_old);
        IDoubleArray T_split = tms.splitForLifetimes(split_state, p1, k1, k2);
    }
}

