/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.correlations;

import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IDynamicalExpectations;
import stallone.api.mc.IMarkovPropagator;
import stallone.api.mc.MarkovModel;
import stallone.mc.RateMatrixPropagator;
import stallone.mc.StationaryDistribution;
import stallone.mc.TransitionMatrixPropagator;

public class DynamicalExpectations
implements IDynamicalExpectations {
    private IMarkovPropagator prop;
    private StationaryDistribution statdist = new StationaryDistribution();
    private IDoubleArray pi;

    public DynamicalExpectations(IDoubleArray M) {
        if (MarkovModel.util.isTransitionMatrix(M)) {
            this.setT(M);
        } else if (MarkovModel.util.isRateMatrix(M)) {
            this.setK(M);
        } else {
            throw new IllegalArgumentException("Trying to construct DynamicalExpectationsSpectral with a Matrix that is neither a transition nor a rate matrix");
        }
        this.pi = Doubles.create.array(M.rows());
    }

    public DynamicalExpectations() {
    }

    @Override
    public final void setT(IDoubleArray _T) {
        this.prop = new TransitionMatrixPropagator(_T);
        this.statdist.setT(_T);
    }

    @Override
    public final void setK(IDoubleArray _K) {
        this.prop = new RateMatrixPropagator(_K);
        this.statdist.setK(_K);
    }

    @Override
    public void setStationaryDistribution(IDoubleArray _pi) {
        this.pi = Doubles.create.array(_pi.getArray());
    }

    private void calculateAlgebra() {
        if (this.prop == null) {
            throw new RuntimeException("Trying to calculate dynamical expectations before setting T or K.");
        }
        if (this.pi == null) {
            this.pi = this.statdist.calculate();
        }
    }

    @Override
    public double calculatePerturbationExpectation(IDoubleArray p0, IDoubleArray a, double t) {
        if (this.pi == null) {
            this.calculateAlgebra();
        }
        IDoubleArray P = this.prop.propagate(t);
        double res = 0.0;
        int i = 0;
        while (i < P.rows()) {
            int j = 0;
            while (j < P.columns()) {
                res += p0.get(i) * P.get(i, j) * a.get(j);
                ++j;
            }
            ++i;
        }
        return res;
    }

    @Override
    public double calculateAutocorrelation(IDoubleArray a, double t) {
        return this.calculateCorrelation(a, a, t);
    }

    @Override
    public double calculateCorrelation(IDoubleArray a, IDoubleArray b, double t) {
        if (this.pi == null) {
            this.calculateAlgebra();
        }
        IDoubleArray P = this.prop.propagate(t);
        double res = 0.0;
        int i = 0;
        while (i < P.rows()) {
            int j = 0;
            while (j < P.columns()) {
                res += a.get(i) * this.pi.get(i) * P.get(i, j) * b.get(j);
                ++j;
            }
            ++i;
        }
        return res;
    }
}

