/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.pcca;

import stallone.api.IAlgorithm;
import stallone.api.algebra.Algebra;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.ints.PrimitiveIntArray;

public final class PCCA
implements IAlgorithm {
    public double INDIKATOR;
    private int[] CLUSTER;
    private int[] SORTARRAY;
    private int[] CLUSTER_SIZE;
    private IDoubleArray FUZZY;
    private IDoubleArray eigenvectors;

    public void setEigenvectors(IDoubleArray dataSet) {
        this.eigenvectors = dataSet;
    }

    @Override
    public void perform() {
        int[] counter;
        IDoubleArray transMatrix;
        IDoubleArray fuzzyAllocation;
        if (this.eigenvectors == null) {
            throw new RuntimeException("No eigenvectors set. Aborting.");
        }
        int noOfClusters = this.eigenvectors.columns();
        int noOfPoints = this.eigenvectors.rows();
        double indikator = 0.0;
        int[] clusterAllocation = new int[noOfPoints];
        if (noOfClusters < 2) {
            fuzzyAllocation = Doubles.create.matrix(noOfPoints, 1, 1.0);
            transMatrix = Doubles.create.matrix(1, 1, 1.0 / this.eigenvectors.get(0, 0));
            double condTrans = 0.0;
            int i = 0;
            while (i < noOfPoints) {
                clusterAllocation[i] = 0;
                ++i;
            }
            counter = new int[]{0, noOfPoints};
        } else {
            if (noOfClusters > noOfPoints) {
                throw new IllegalArgumentException("There are more clusters than points given!");
            }
            if (noOfClusters == noOfPoints) {
                fuzzyAllocation = Doubles.create.array(noOfPoints, noOfPoints);
                int i = 0;
                while (i < fuzzyAllocation.rows()) {
                    fuzzyAllocation.set(i, i, 1.0);
                    ++i;
                }
                transMatrix = Algebra.util.inverse(this.eigenvectors);
                counter = new int[noOfPoints + 1];
                i = 0;
                while (i < noOfPoints) {
                    clusterAllocation[i] = i;
                    counter[i + 1] = 1;
                    ++i;
                }
            } else {
                int j;
                double skalar = 0.0;
                double maxDist = 0.0;
                double comp = 0.0;
                double entry = 0.0;
                int[] index = new int[noOfClusters];
                int[] indexAll = Ints.create.arrayRange(0, noOfClusters).getArray();
                IDoubleArray orthoSys = this.eigenvectors.copy();
                int i = 0;
                while (i < noOfPoints) {
                    j = i + 1;
                    while (j < noOfPoints) {
                        double dij = Algebra.util.distance(this.eigenvectors.viewRow(i), this.eigenvectors.viewRow(j));
                        if (dij > maxDist) {
                            maxDist = dij;
                            index[0] = i;
                            index[1] = j;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < noOfPoints) {
                    j = 0;
                    while (j < orthoSys.columns()) {
                        orthoSys.set(i, j, orthoSys.get(i, j) - this.eigenvectors.get(0, j));
                        ++j;
                    }
                    ++i;
                }
                double d = Algebra.util.norm(orthoSys.viewRow(index[1]));
                Algebra.util.scale(1.0 / d, orthoSys);
                int i2 = 2;
                while (i2 < noOfClusters) {
                    maxDist = 0.0;
                    IDoubleArray dummy = orthoSys.viewRow(index[i2 - 1]).copy();
                    int j2 = 0;
                    while (j2 < noOfPoints) {
                        skalar = Algebra.util.dot(dummy, orthoSys.viewRow(j2));
                        int k = 0;
                        while (k < dummy.size()) {
                            orthoSys.set(j2, k, orthoSys.get(j2, k) - dummy.get(k) * skalar);
                            ++k;
                        }
                        comp = Algebra.util.norm(orthoSys.viewRow(j2));
                        if (comp > maxDist) {
                            maxDist = comp;
                            index[i2] = j2;
                        }
                        ++j2;
                    }
                    double normi = Algebra.util.norm(orthoSys.viewRow(index[i2]));
                    Algebra.util.scale(1.0 / normi, orthoSys);
                    ++i2;
                }
                transMatrix = Algebra.util.inverse(this.eigenvectors.view(index, indexAll));
                fuzzyAllocation = Doubles.create.matrix(Algebra.util.product(this.eigenvectors, transMatrix).getTable());
                counter = new int[noOfClusters + 1];
                i2 = 0;
                while (i2 < noOfPoints) {
                    comp = 0.0;
                    int j3 = 0;
                    while (j3 < noOfClusters) {
                        entry = fuzzyAllocation.get(i2, j3);
                        if (entry < indikator) {
                            indikator = entry;
                        }
                        if (entry > comp) {
                            clusterAllocation[i2] = j3;
                            comp = entry;
                        }
                        ++j3;
                    }
                    int n = clusterAllocation[i2] + 1;
                    counter[n] = counter[n] + 1;
                    ++i2;
                }
            }
        }
        int[] counter2 = new int[noOfClusters];
        int[] sortarray = new int[noOfPoints];
        int i = 1;
        while (i < counter.length) {
            int n = i;
            counter[n] = counter[n] + counter[i - 1];
            ++i;
        }
        i = 0;
        while (i < sortarray.length) {
            sortarray[counter[clusterAllocation[i]] + counter2[clusterAllocation[i]]] = i;
            int n = clusterAllocation[i];
            counter2[n] = counter2[n] + 1;
            ++i;
        }
        this.INDIKATOR = indikator;
        this.FUZZY = fuzzyAllocation;
        this.CLUSTER = clusterAllocation;
        this.SORTARRAY = sortarray;
        this.CLUSTER_SIZE = counter2;
    }

    public IIntArray getClusters() {
        return new PrimitiveIntArray(this.CLUSTER);
    }

    public IIntArray getClusterSize() {
        return new PrimitiveIntArray(this.CLUSTER_SIZE);
    }

    public IDoubleArray getFuzzy() {
        return this.FUZZY;
    }

    public IIntArray getPermutationArray() {
        return new PrimitiveIntArray(this.SORTARRAY);
    }
}

