/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IDeltaGDistribution;

public class DeltaGGaussian
implements IDeltaGDistribution {
    private double mu;
    private double sigma;
    private int stateA;
    private int stateB;

    public DeltaGGaussian(double _mu, double _sigma, int _A, int _B) {
        this.mu = _mu;
        this.sigma = _sigma;
        this.stateA = _A;
        this.stateB = _B;
    }

    @Override
    public boolean accept(IDoubleArray pi, double randomNumber) {
        double diff = Math.log(pi.get(this.stateA) / pi.get(this.stateB)) - this.mu;
        double dbs = diff / this.sigma;
        double model = Math.exp(-0.5 * dbs * dbs);
        return randomNumber < model;
    }
}

