/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IReversibleSamplingStep;
import stallone.mc.sampling.TransitionMatrixSamplingTools;
import stallone.util.MathTools;

public class Step_Rev_Quad_MC
implements IReversibleSamplingStep {
    private int n;
    private IDoubleArray C;
    private IDoubleArray T;
    private IDoubleArray mu;
    private double Tii_backup;
    private double Tij_backup;
    private double Tji_backup;
    private double Tjj_backup;
    int nprop = 0;
    int nacc = 0;

    @Override
    public void init(IDoubleArray _C, IDoubleArray _T, IDoubleArray _mu) {
        this.n = _C.rows();
        this.C = _C;
        this.T = _T;
        this.mu = _mu;
    }

    public boolean sampleQuad(int i, int j) {
        boolean accept;
        double dmax;
        double q = this.mu.get(j) / this.mu.get(i);
        double dmin = Math.max(-this.T.get(i, i), -q * this.T.get(j, j));
        if (dmin == (dmax = Math.min(this.T.get(i, j), q * this.T.get(j, i)))) {
            return false;
        }
        if (dmin > dmax) {
            throw new RuntimeException("Error during reversible edge shift in Transition Matrix Sampling: Have reached an inconsistency between elements. dmin > dmax with:dmin = Math.max(-T.get(i, i), -q * T.get(j, j))" + dmin + " = Math.max(-" + this.T.get(i, i) + ", -" + q + " * " + this.T.get(j, j) + ")" + "dmax = Math.min(T.get(i, j), q * T.get(j, i))" + dmax + " = Math.min(" + this.T.get(i, j) + ", " + q + " * " + this.T.get(j, i) + ")" + "at i = " + i + "   j = " + j);
        }
        double d1 = 0.0;
        double d2 = 0.0;
        d1 = MathTools.randomDouble(dmin, dmax);
        d2 = d1 / q;
        ++this.nprop;
        double prop = Math.sqrt(((this.T.get(i, j) - d1) * (this.T.get(i, j) - d1) + (this.T.get(j, i) - d2) * (this.T.get(j, i) - d2)) / (this.T.get(i, j) * this.T.get(i, j) + this.T.get(j, i) * this.T.get(j, i)));
        double pacc = prop * Math.pow((this.T.get(i, i) + d1) / this.T.get(i, i), this.C.get(i, i)) * Math.pow((this.T.get(i, j) - d1) / this.T.get(i, j), this.C.get(i, j)) * Math.pow((this.T.get(j, j) + d2) / this.T.get(j, j), this.C.get(j, j)) * Math.pow((this.T.get(j, i) - d2) / this.T.get(j, i), this.C.get(j, i));
        boolean bl = accept = Math.random() <= pacc;
        if (accept) {
            ++this.nacc;
            this.Tii_backup = this.T.get(i, i);
            this.Tij_backup = this.T.get(i, j);
            this.Tji_backup = this.T.get(j, i);
            this.Tjj_backup = this.T.get(j, j);
            this.T.set(i, j, this.T.get(i, j) + -d1);
            this.T.set(i, i, this.T.get(i, i) + (1.0 - API.doubles.sumRow(this.T, i)));
            this.T.set(j, i, this.T.get(i, j) / q);
            this.T.set(j, j, this.T.get(j, j) + (1.0 - API.doubles.sumRow(this.T, j)));
            if (!(TransitionMatrixSamplingTools.isElementIn01(this.T, i, i) && TransitionMatrixSamplingTools.isElementIn01(this.T, i, j) && TransitionMatrixSamplingTools.isElementIn01(this.T, j, i) && TransitionMatrixSamplingTools.isElementIn01(this.T, j, j))) {
                this.T.set(i, i, this.Tii_backup);
                this.T.set(i, j, this.Tij_backup);
                this.T.set(j, j, this.Tjj_backup);
                this.T.set(j, i, this.Tji_backup);
                accept = false;
            }
        }
        return accept;
    }

    @Override
    public boolean step() {
        int j;
        int i;
        while ((i = MathTools.randomInt(0, this.n)) == (j = MathTools.randomInt(0, this.n))) {
        }
        return this.sampleQuad(i, j);
    }

    public int[] getStepCount() {
        int[] count = new int[]{this.nprop, this.nacc};
        return count;
    }
}

