/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import cern.jet.random.Beta;
import cern.jet.random.engine.MersenneTwister;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.api.mc.IReversibleSamplingStep;
import stallone.mc.sampling.TransitionMatrixSamplingTools;
import stallone.util.MathTools;

public class Step_Rev_Row_Beta
implements IReversibleSamplingStep {
    private int n;
    private IDoubleArray C;
    private int[] dof;
    private double[] Csum;
    private IDoubleArray mu;
    private IDoubleArray u;
    private IDoubleArray T;
    private Beta[] rowDistribution;
    private double[] backupRow;
    int nprop = 0;
    int nacc = 0;

    @Override
    public void init(IDoubleArray _C, IDoubleArray _T, IDoubleArray _mu) {
        this.n = _C.rows();
        this.C = _C;
        this.T = _T;
        this.mu = _mu;
        this.backupRow = new double[this.n];
        this.u = API.doublesNew.array(this.n);
        for (int i = 0; i < this.u.size(); ++i) {
            this.u.set(i, -Math.log(this.mu.get(i)));
        }
        this.dof = new int[this.C.rows()];
        this.Csum = new double[this.C.rows()];
        IDoubleIterator it = this.C.nonzeroIterator();
        while (it.hasNext()) {
            int j;
            int i = it.row();
            if (this.C.get(i, j = it.column()) >= -1.0) {
                int n = i;
                this.dof[n] = this.dof[n] + 1;
                int n2 = i;
                this.Csum[n2] = this.Csum[n2] + this.C.get(i, j);
            }
            it.advance();
        }
        this.rowDistribution = new Beta[this.Csum.length];
        for (int i = 0; i < this.Csum.length; ++i) {
            double alpha = this.Csum[i] + (double)this.dof[i] - this.C.get(i, i) - 1.0;
            double beta = this.C.get(i, i) + 1.0;
            this.rowDistribution[i] = new Beta(alpha, beta, new MersenneTwister());
        }
        if (!this.checkCounts()) {
            throw new IllegalArgumentException("This Matrix cannot be sampled reversibly as it has no row with positive diagonal counts and at least 2 degrees of freedom");
        }
    }

    protected final boolean checkCounts() {
        boolean valid = false;
        for (int i = 0; i < this.C.rows(); ++i) {
            if (!(this.C.get(i, i) > -1.0) || this.dof[i] < 2) continue;
            valid = true;
        }
        return valid;
    }

    private void backupRow(int row) {
        for (int k = 0; k < this.n; ++k) {
            this.backupRow[k] = this.T.get(row, k);
        }
    }

    private void restoreRow(int row) {
        for (int k = 0; k < this.n; ++k) {
            this.T.set(row, k, this.backupRow[k]);
        }
    }

    public void sampleRow(int i) {
        int k;
        double x = this.rowDistribution[i].nextDouble();
        double a = x / (1.0 - this.T.get(i, i));
        this.backupRow(i);
        double sum = 0.0;
        for (k = 0; k < this.T.columns(); ++k) {
            if (k == i) continue;
            this.T.set(i, k, this.T.get(i, k) * a);
            sum += this.T.get(i, k);
        }
        this.T.set(i, i, 1.0 - sum);
        if (TransitionMatrixSamplingTools.isRowIn01(this.T, i)) {
            this.u.set(i, this.u.get(i) + Math.log(a));
            this.mu.set(i, Math.exp(-this.u.get(i)));
            if (Math.abs(API.doubles.min(this.u)) > 1.0) {
                API.alg.addTo(this.u, -API.doubles.min(this.u));
                for (k = 0; k < this.T.columns(); ++k) {
                    this.mu.set(k, Math.exp(-this.u.get(k)));
                }
            }
        } else {
            this.restoreRow(i);
        }
    }

    @Override
    public boolean step() {
        int i = MathTools.randomInt(0, this.T.rows());
        while (this.C.get(i, i) <= 0.0 || this.dof[i] < 2) {
            i = MathTools.randomInt(0, this.T.rows());
        }
        this.sampleRow(i);
        ++this.nprop;
        ++this.nacc;
        return true;
    }

    public int[] getStepCount() {
        int[] count = new int[]{this.nprop, this.nacc};
        return count;
    }
}

