/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.tpt;

import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.impl.SparseObjectMatrix2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.graph.IIntGraph;
import stallone.doubles.PrimitiveDoubleTools;
import stallone.ints.PrimitiveIntTools;
import stallone.mc.tpt.Bisection;

public class PathwayDecomposition {
    SparseObjectMatrix2D F;
    BigDecimal[] influxes = null;
    BigDecimal[] outfluxes = null;
    private double[] Q = null;
    private int[] A = null;
    private int[] B = null;
    private boolean[] inA = null;
    private boolean[] inB = null;
    private int[] currentPathway = null;
    private BigDecimal currentFlux = BigDecimal.ZERO;

    public PathwayDecomposition(IDoubleArray _F, double[] _Q, int[] _A, int[] _B) {
        int j;
        this.Q = _Q;
        this.A = _A;
        this.B = _B;
        IIntGraph g = API.graphNew.intMatrixGraph(_F);
        this.inA = new boolean[_F.rows()];
        int i = 0;
        while (i < this.A.length) {
            this.inA[this.A[i]] = true;
            ++i;
        }
        this.inB = new boolean[_F.rows()];
        i = 0;
        while (i < this.B.length) {
            this.inB[this.B[i]] = true;
            ++i;
        }
        this.F = new SparseObjectMatrix2D(_F.rows(), _F.rows());
        i = 0;
        while (i < _F.rows()) {
            j = 0;
            while (j < _F.rows()) {
                if (_F.get(i, j) != 0.0) {
                    this.F.set(i, j, new BigDecimal(_F.get(i, j)));
                }
                ++j;
            }
            ++i;
        }
        this.influxes = new BigDecimal[_F.rows()];
        this.outfluxes = new BigDecimal[_F.rows()];
        i = 0;
        while (i < this.influxes.length) {
            this.influxes[i] = BigDecimal.ZERO;
            this.outfluxes[i] = BigDecimal.ZERO;
            ++i;
        }
        i = 0;
        while (i < this.F.rows()) {
            j = 0;
            while (j < this.F.rows()) {
                if (this.F.get(i, j) != null) {
                    this.influxes[j] = this.influxes[j].add((BigDecimal)this.F.get(i, j));
                    this.outfluxes[i] = this.outfluxes[i].add((BigDecimal)this.F.get(i, j));
                }
                ++j;
            }
            ++i;
        }
        int[] IQ = PrimitiveDoubleTools.sortedIndexes(this.Q);
        int i2 = 0;
        while (i2 < IQ.length) {
            int s = IQ[i2];
            if (!this.influxes[s].equals(BigDecimal.ZERO) && !this.outfluxes[s].equals(BigDecimal.ZERO)) {
                BigDecimal err = this.outfluxes[s].subtract(this.influxes[s]);
                int[] neighbors = g.getNeighbors(s).getArray();
                int ilargest = 0;
                double flargest = _F.get(s, neighbors[0]);
                int j2 = 1;
                while (j2 < neighbors.length) {
                    if (_F.get(s, neighbors[j2]) > flargest) {
                        ilargest = j2;
                        flargest = _F.get(s, neighbors[j2]);
                    }
                    ++j2;
                }
                this.F.set(s, neighbors[ilargest], ((BigDecimal)this.F.get(s, neighbors[ilargest])).subtract(err));
                this.outfluxes[s] = this.outfluxes[s].subtract(err);
                this.influxes[neighbors[ilargest]] = this.influxes[neighbors[ilargest]].subtract(err);
            }
            ++i2;
        }
    }

    public int[][] removeEdge(int[][] set, int[] edge) {
        int[][] res = new int[set.length - 1][];
        int i = 0;
        int k = 0;
        while (i < set.length) {
            if (set[i][0] != edge[0] || set[i][1] != edge[1]) {
                res[k++] = set[i];
            }
            ++i;
        }
        return res;
    }

    public int[][] findGap(int[][] pathway, int[] S1, int[] S2) {
        if (pathway.length == 0) {
            return new int[][]{S1, S2};
        }
        if (!PrimitiveIntTools.contains(S1, pathway[0][0])) {
            return new int[][]{S1, {pathway[0][0]}};
        }
        if (!PrimitiveIntTools.contains(S2, pathway[pathway.length - 1][1])) {
            return new int[][]{{pathway[pathway.length - 1][1]}, S2};
        }
        int i = 0;
        while (i < pathway.length - 1) {
            if (pathway[i][1] != pathway[i + 1][0]) {
                return new int[][]{{pathway[i][1]}, {pathway[i + 1][0]}};
            }
            ++i;
        }
        return null;
    }

    public int[][] insertIntoPathway(int[][] pathway, int[] b) {
        int i = 0;
        while (i < pathway.length) {
            if (this.Q[b[1]] <= this.Q[pathway[i][0]]) {
                int[][] res = new int[0][2];
                if (i > 0) {
                    res = PrimitiveIntTools.subarray(pathway, 0, i);
                }
                res = PrimitiveIntTools.concat(res, b);
                res = PrimitiveIntTools.concat(res, PrimitiveIntTools.subarray(pathway, i, pathway.length));
                return res;
            }
            ++i;
        }
        int[][] res = PrimitiveIntTools.concat(pathway, b);
        return res;
    }

    public int[] edges2vertices(int[][] path) {
        int[] res = new int[path.length + 1];
        int i = 0;
        while (i < path.length) {
            res[i] = path[i][0];
            ++i;
        }
        res[res.length - 1] = path[path.length - 1][1];
        return res;
    }

    public BigDecimal computeCurrentFlux() {
        BigDecimal res = (BigDecimal)this.F.get(this.currentPathway[0], this.currentPathway[1]);
        System.out.println(String.valueOf(this.currentPathway[0]) + "\t" + this.currentPathway[1] + "\t" + this.F.get(this.currentPathway[0], this.currentPathway[1]));
        int i = 1;
        while (i < this.currentPathway.length - 1) {
            BigDecimal w = (BigDecimal)this.F.get(this.currentPathway[i], this.currentPathway[i + 1]);
            System.out.println(String.valueOf(this.currentPathway[i]) + "\t" + this.currentPathway[i + 1] + "\t" + this.F.get(this.currentPathway[i], this.currentPathway[i + 1]));
            if (w.compareTo(res) < 1) {
                res = w;
            }
            ++i;
        }
        this.currentFlux = res;
        return res;
    }

    public void subtractCurrentPath() {
        int i = 0;
        while (i < this.currentPathway.length - 1) {
            this.F.set(this.currentPathway[i], this.currentPathway[i + 1], ((BigDecimal)this.F.get(this.currentPathway[i], this.currentPathway[i + 1])).subtract(this.currentFlux));
            ++i;
        }
    }

    public int[] nextPathway() {
        ArrayList<int[]> Elist = new ArrayList<int[]>();
        int i = 0;
        while (i < this.F.rows()) {
            int j = 0;
            while (j < this.F.rows()) {
                if (this.F.get(i, j) != null && ((BigDecimal)this.F.get(i, j)).compareTo(BigDecimal.ZERO) > 0) {
                    Elist.add(new int[]{i, j});
                }
                ++j;
            }
            ++i;
        }
        int[][] E = PrimitiveIntTools.List2Array2(Elist);
        Object pathway = new int[][]{};
        int[][] gap = null;
        while ((gap = this.findGap((int[][])pathway, this.A, this.B)) != null) {
            Bisection bi = new Bisection(this.F, E, gap[0], gap[1]);
            int[] b = bi.bottleneck();
            if (b == null) {
                return null;
            }
            E = this.removeEdge(E, b);
            pathway = this.insertIntoPathway((int[][])pathway, b);
        }
        this.currentPathway = this.edges2vertices((int[][])pathway);
        this.computeCurrentFlux();
        this.subtractCurrentPath();
        return this.currentPathway;
    }

    public int[] getCurrentPathway() {
        return this.currentPathway;
    }

    public BigDecimal getCurrentFlux() {
        return this.currentFlux;
    }

    private void printFlux() {
        IntArrayList I = new IntArrayList();
        IntArrayList J = new IntArrayList();
        ObjectArrayList O = new ObjectArrayList();
        this.F.getNonZeros(I, J, O);
        int i = 0;
        while (i < I.size()) {
            System.out.println(String.valueOf(I.get(i)) + " " + J.get(i) + "\t" + ((BigDecimal)O.get(i)).floatValue());
            ++i;
        }
        System.out.println();
    }

    public static void main(String[] args) {
        IDoubleArray Fnet = API.doublesNew.array(new double[][]{{0.0, 0.00771791768, 0.00308716707, 0.0, 0.0}, {0.0, 0.0, 5.14527845E-4, 0.0, 0.00720338983}, {0.0, 0.0, 0.0, 0.0, 0.00360169492}, {0.0, 4.33680869E-19, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}});
        double[] Q = new double[]{0.0, 0.35714286, 0.42857143, 0.35714286, 1.0};
        int[] A = new int[1];
        int[] B = new int[]{4};
        PathwayDecomposition decomp = new PathwayDecomposition(Fnet, Q, A, B);
        decomp.printFlux();
        decomp.nextPathway();
        int[] p1 = decomp.getCurrentPathway();
        PrimitiveIntTools.print(p1);
        System.out.println(decomp.getCurrentFlux());
        System.out.println();
        decomp.printFlux();
        decomp.nextPathway();
        int[] p2 = decomp.getCurrentPathway();
        PrimitiveIntTools.print(p2);
        System.out.println(decomp.getCurrentFlux());
        System.out.println();
        decomp.printFlux();
        decomp.nextPathway();
        int[] p3 = decomp.getCurrentPathway();
        PrimitiveIntTools.print(p3);
        System.out.println(decomp.getCurrentFlux());
        System.out.println();
        decomp.printFlux();
    }
}

