/*
 * Decompiled with CFR 0.152.
 */
package stallone.potential;

import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDifferentiableMetric;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.potential.AbstractPotential;

public class CoulombSystem
extends AbstractPotential {
    private static double epsilon0 = 5.727657013E-4;
    private double epsilonr = 1.0;
    private IDoubleArray coordinates;
    private IDifferentiableMetric<IDoubleArray> metric;
    private int natoms = 0;
    private boolean[][] bonded;
    private IDoubleArray charges;
    private double energy;
    private IDoubleArray gradient;

    public CoulombSystem(IDoubleArray _charges, double _epsilonr) {
        this.natoms = _charges.size();
        this.bonded = new boolean[_charges.size()][_charges.size()];
        this.charges = _charges;
        this.epsilonr = _epsilonr;
        this.gradient = Doubles.create.array(_charges.size(), 3);
    }

    public CoulombSystem(IDoubleArray _charges, IIntArray _bonded, double _epsilonr) {
        if (_bonded.columns() != 2) {
            throw new IllegalArgumentException("_bonded must be a nx2 table");
        }
        this.natoms = _charges.size();
        this.bonded = new boolean[_charges.size()][_charges.size()];
        int i = 0;
        while (i < _bonded.size()) {
            this.bonded[_bonded.get((int)i, (int)0)][_bonded.get((int)i, (int)1)] = true;
            ++i;
        }
        this.charges = _charges;
        this.epsilonr = _epsilonr;
        this.gradient = Doubles.create.array(_charges.size(), 3);
    }

    public CoulombSystem(IDoubleArray _charges, boolean[][] _bonded, double _epsilonr) {
        this.natoms = _charges.size();
        this.bonded = _bonded;
        this.charges = _charges;
        this.epsilonr = _epsilonr;
        this.gradient = Doubles.create.array(_charges.size(), 3);
    }

    public void setMetric(IDifferentiableMetric<IDoubleArray> m) {
        this.metric = m;
    }

    @Override
    public void setCoordinates(IDoubleArray _coordinates) {
        this.coordinates = _coordinates.copy();
    }

    @Override
    public boolean calculate() {
        this.energy = 0.0;
        int i = 0;
        while (i < this.gradient.size()) {
            this.gradient.set(i, 0.0);
            ++i;
        }
        i = 0;
        while (i < this.natoms - 1) {
            int j = i + 1;
            while (j < this.natoms) {
                if (!this.bonded[i][j]) {
                    IDoubleArray c1 = this.coordinates.viewRow(i);
                    IDoubleArray c2 = this.coordinates.viewRow(j);
                    double d = this.metric.distance(c1, c2);
                    double e = this.charges.get(i) * this.charges.get(j) / (Math.PI * 4 * epsilon0 * this.epsilonr * d);
                    this.energy += e;
                    double fm = -this.charges.get(i) * this.charges.get(j) / (Math.PI * 4 * epsilon0 * this.epsilonr * d * d);
                    IDoubleArray mg1 = this.metric.gradientX(c1, c2);
                    int dim = 0;
                    while (dim < 3) {
                        this.gradient.set(i, dim, this.gradient.get(i, dim) + fm * mg1.get(dim));
                        ++dim;
                    }
                    IDoubleArray mg2 = this.metric.gradientY(c1, c2);
                    int dim2 = 0;
                    while (dim2 < 3) {
                        this.gradient.set(j, dim2, this.gradient.get(j, dim2) + fm * mg2.get(dim2));
                        ++dim2;
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getNDimensions() {
        return this.natoms * 3;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public IDoubleArray getGradient() {
        return this.gradient;
    }

    @Override
    public IDoubleArray getCoordinates() {
        return this.coordinates;
    }

    @Override
    public int getNumberOfVariables() {
        return this.coordinates.size();
    }
}

