/*
 * Decompiled with CFR 0.152.
 */
package stallone.potential;

import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.potential.IMassEnergyModel;
import stallone.potential.AbstractPotential;

public class HarmonicOscillator
extends AbstractPotential
implements IMassEnergyModel {
    private IDoubleArray gradArr = Doubles.create.array(1);
    private IDoubleArray xArr = Doubles.create.array(1);
    private IDoubleArray massArr = Doubles.create.arrayFrom(1.0);
    private double k;
    private double x = 1.0;
    private double v;
    private double a;
    private double energy;
    private double gradient;

    public HarmonicOscillator(double _k) {
        this.k = _k;
    }

    @Override
    public void setCoordinates(IDoubleArray coordinates) {
        this.x = coordinates.get(0);
    }

    @Override
    public boolean calculate() {
        this.energy = 0.5 * this.k * this.x * this.x;
        this.gradient = this.k * this.x;
        return true;
    }

    @Override
    public int getNDimensions() {
        return 1;
    }

    @Override
    public IDoubleArray getMasses() {
        return this.massArr;
    }

    @Override
    public IDoubleArray getGradient() {
        this.gradArr.set(0, this.gradient);
        return this.gradArr;
    }

    @Override
    public IDoubleArray getCoordinates() {
        this.xArr.set(0, this.x);
        return this.xArr;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public int getNumberOfVariables() {
        return 1;
    }
}

