/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat;

import java.util.Arrays;
import java.util.List;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleList;
import stallone.util.CommandLineParser;

public class EventBinningCorrelator {
    private IDoubleArray lagtimes;
    private IDoubleArray averageWidths;
    private double samplingTime = 1.0;
    private IDoubleArray correlation;
    private IDoubleArray weights;
    private double sum = 0.0;
    private double sumOfWeights = 0.0;

    public EventBinningCorrelator(IDoubleArray _lagtimes, IDoubleArray _averageWidths, double _samplingTime) {
        if (_lagtimes.size() != _averageWidths.size()) {
            throw new IllegalArgumentException("Number of lagtimes does not match number of average widths in correlate.");
        }
        this.lagtimes = _lagtimes;
        this.averageWidths = _averageWidths;
        this.samplingTime = _samplingTime;
        this.correlation = API.doublesNew.array(this.lagtimes.size());
        this.weights = API.doublesNew.array(this.lagtimes.size());
    }

    public static String getUsageString() {
        String res = "EventCorrelator\nCorrelates the given columns of all files passed.-i <trajectorie(s)>\n\n-columns <time> <D> <A>\n-samplingtime <dt>\n-maxtime <maxy>\n-latmult <mult>\n-windowfraction <fw>\n-subtractmean\n";
        return res;
    }

    public static CommandLineParser parseArguments(String[] args) {
        CommandLineParser parser = new CommandLineParser();
        parser.addStringArrayCommand("i", true);
        parser.addCommand("columns", true);
        parser.addIntArgument("columns", true);
        parser.addIntArgument("columns", true);
        parser.addIntArgument("columns", true);
        parser.addIntCommand("maxtime", true);
        parser.addDoubleCommand("lagmult", true);
        parser.addIntCommand("samplingtime", true);
        parser.addDoubleCommand("windowfraction", true);
        parser.addCommand("subtractmean", true);
        if (!parser.parse(args)) {
            throw new IllegalArgumentException("Parsing error!");
        }
        return parser;
    }

    private static IDoubleArray cumulate(IDoubleArray data) {
        IDoubleArray res = API.doublesNew.array(data.size() + 1);
        res.set(0, 0.0);
        int i = 1;
        while (i < res.size()) {
            res.set(i, res.get(i - 1) + data.get(i - 1));
            ++i;
        }
        return res;
    }

    public double correlate(IDoubleArray time, IDoubleArray data, double tau, double windowSize) {
        if (time.size() != data.size()) {
            throw new IllegalArgumentException("Number of time points does not match number of data points in correlate.");
        }
        IDoubleArray cumdata = EventBinningCorrelator.cumulate(data);
        Window w1 = new Window(time, data, windowSize);
        w1.init(windowSize / 2.0);
        Window w2 = new Window(time, data, windowSize);
        w2.init(windowSize / 2.0 + tau);
        double sum = 0.0;
        double count = 0.0;
        while (!w2.endOfData()) {
            if (!w1.isEmpty() && !w2.isEmpty()) {
                double x1 = (cumdata.get(w1.r) - cumdata.get(w1.l)) / (double)(w1.r - w1.l);
                double x2 = (cumdata.get(w2.r) - cumdata.get(w2.l)) / (double)(w2.r - w2.l);
                sum += x1 * x2;
                count += 1.0;
            }
            w1.advance(this.samplingTime);
            w2.advance(this.samplingTime);
        }
        return sum / count;
    }

    public IDoubleArray correlate(IDoubleArray time, IDoubleArray data) {
        IDoubleArray res = API.doublesNew.array(this.lagtimes.size());
        int i = 0;
        while (i < res.size()) {
            res.set(i, this.correlate(time, data, this.lagtimes.get(i), this.averageWidths.get(i)));
            ++i;
        }
        return res;
    }

    public void add(IDoubleArray time, IDoubleArray data) {
        IDoubleArray c = this.correlate(time, data);
        int i = 0;
        while (i < c.size()) {
            if (!Double.isNaN(c.get(i))) {
                this.correlation.set(i, this.correlation.get(i) + (double)data.size() * c.get(i));
                this.weights.set(i, this.weights.get(i) + (double)data.size());
            }
            ++i;
        }
        this.sum += API.doubles.sum(data);
        this.sumOfWeights += (double)time.size();
    }

    public IDoubleArray getCorrelation() {
        IDoubleArray res = API.doublesNew.array(this.correlation.size());
        int i = 0;
        while (i < res.size()) {
            res.set(i, this.correlation.get(i) / this.weights.get(i));
            ++i;
        }
        return res;
    }

    public IDoubleArray getCorrelationMeanFree() {
        IDoubleArray res = API.doublesNew.array(this.correlation.size());
        double shift = this.sum / this.sumOfWeights * (this.sum / this.sumOfWeights);
        System.out.println("# square mean = " + shift);
        int i = 0;
        while (i < res.size()) {
            res.set(i, this.correlation.get(i) / this.weights.get(i) - shift);
            ++i;
        }
        return res;
    }

    public void reset() {
        this.correlation.zero();
        this.weights.zero();
        this.sum = 0.0;
        this.sumOfWeights = 0.0;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(EventBinningCorrelator.getUsageString());
            System.exit(0);
        }
        CommandLineParser parser = EventBinningCorrelator.parseArguments(args);
        List<String> inputFiles = Arrays.asList(parser.getStringArray("i"));
        int timecol = parser.getInt("columns", 0);
        int col1 = parser.getInt("columns", 1);
        int col2 = parser.getInt("columns", 2);
        double lagtmult = parser.getDouble("lagmult", 0);
        int maxtime = parser.getInt("maxtime", 0);
        int samplingtime = parser.getInt("samplingtime", 0);
        boolean subtractMean = parser.hasCommand("subtractmean");
        IDoubleList lagtimes = API.doublesNew.listFrom(0.0, 1.0);
        while (lagtimes.get(lagtimes.size() - 1) < (double)maxtime) {
            lagtimes.append((int)((lagtimes.get(lagtimes.size() - 1) + 1.0) * lagtmult));
        }
        IDoubleArray averageWidths = API.doublesNew.array(lagtimes.size());
        int i = 0;
        while (i < averageWidths.size()) {
            averageWidths.set(i, 1.0);
            ++i;
        }
        EventBinningCorrelator correlator = new EventBinningCorrelator(lagtimes, averageWidths, samplingtime);
        int i2 = 0;
        while (i2 < inputFiles.size()) {
            IDoubleArray time = API.data.readColumn(inputFiles.get(i2), timecol);
            IDoubleArray don = API.data.readColumn(inputFiles.get(i2), col1);
            IDoubleArray acc = API.data.readColumn(inputFiles.get(i2), col2);
            IDoubleArray E = API.doublesNew.array(don.size());
            int j = 0;
            while (j < E.size()) {
                E.set(j, acc.get(j) / (don.get(j) + acc.get(j)));
                ++j;
            }
            correlator.add(time, E);
            ++i2;
        }
        IDoubleArray corr = null;
        corr = subtractMean ? correlator.getCorrelationMeanFree() : correlator.getCorrelation();
        int i3 = 0;
        while (i3 < lagtimes.size()) {
            System.out.println(String.valueOf(lagtimes.get(i3)) + "\t" + corr.get(i3));
            ++i3;
        }
    }

    class Window {
        public IDoubleArray times;
        public IDoubleArray data;
        public double width;
        public double t;
        public double tl;
        public double tr;
        public int l = 0;
        public int r = 0;

        public Window(IDoubleArray _times, IDoubleArray _data, double _width) {
            this.times = _times;
            this.data = _data;
            this.width = _width;
        }

        public void init(double _t) {
            this.t = _t;
            this.tl = this.t - this.width / 2.0;
            this.tr = this.t + this.width / 2.0;
            this.l = 0;
            this.r = 0;
            this.advance(0.0);
        }

        public void advance(double dt) {
            this.t += dt;
            this.tl = this.t - this.width / 2.0;
            this.tr = this.t + this.width / 2.0;
            while (this.l < this.times.size()) {
                if (!(this.times.get(this.l) < this.tl)) break;
                ++this.l;
            }
            while (this.r < this.times.size()) {
                if (!(this.times.get(this.r) < this.tr)) break;
                ++this.r;
            }
        }

        public boolean isEmpty() {
            return this.l == this.r;
        }

        public boolean endOfData() {
            return this.l >= this.times.size();
        }
    }
}

