/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat;

import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.function.IParametricFunction;
import stallone.api.stat.IParameterEstimator;

public class GaussianUnivariate
implements IParametricFunction,
IParameterEstimator {
    private IDoubleArray parameters;
    private double a;
    private double b;
    private double sumRunning;
    private double sumSquaredRunning;
    private double totalWeightRunning;

    public GaussianUnivariate(IDoubleArray _parameters) {
        this.parameters = _parameters;
        this.precalc();
    }

    public GaussianUnivariate(double mean, double variance) {
        this.parameters = Doubles.create.arrayFrom(mean, variance);
        this.precalc();
    }

    private final void precalc() {
        this.a = Math.sqrt(1.0 / (this.parameters.get(1) * 2.0 * Math.PI));
        this.b = -1.0 / (2.0 * this.parameters.get(1));
    }

    @Override
    public IDoubleArray getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(IDoubleArray par) {
        this.parameters = par;
        this.precalc();
    }

    @Override
    public int getNumberOfVariables() {
        return 1;
    }

    @Override
    public double f(double ... x) {
        double dx = x[0] - this.parameters.get(0);
        return this.a * Math.exp(this.b * dx * dx);
    }

    @Override
    public double f(IDoubleArray x) {
        double dx = x.get(0) - this.parameters.get(0);
        return this.a * Math.exp(this.b * dx * dx);
    }

    @Override
    public IDoubleArray estimate(IDataSequence data) {
        IDoubleArray par = Doubles.create.array(2);
        double mean = 0.0;
        for (IDoubleArray a : data) {
            mean += a.get(0);
        }
        mean /= (double)data.size();
        double var = 0.0;
        for (IDoubleArray a : data) {
            double d = a.get(0) - mean;
            var += d * d;
        }
        par.set(0, mean);
        par.set(1, var /= (double)(data.size() - 1));
        return par;
    }

    @Override
    public IDoubleArray estimate(IDataSequence data, IDoubleArray weights) {
        IDoubleArray par = Doubles.create.array(2);
        double W = 0.0;
        double mean = 0.0;
        int i = 0;
        while (i < data.size()) {
            mean += weights.get(i) * data.get(i).get(0);
            W += weights.get(i);
            ++i;
        }
        mean /= W;
        double var = 0.0;
        int i2 = 0;
        while (i2 < data.size()) {
            double d = data.get(i2).get(0) - mean;
            var += weights.get(i2) * d * d;
            ++i2;
        }
        par.set(0, mean);
        par.set(1, var /= W - 1.0);
        return par;
    }

    @Override
    public void initialize() {
        this.sumRunning = 0.0;
        this.sumSquaredRunning = 0.0;
        this.totalWeightRunning = 0.0;
    }

    @Override
    public void initialize(IDoubleArray initPar) {
        this.sumRunning = 0.0;
        this.sumSquaredRunning = 0.0;
        this.totalWeightRunning = 0.0;
    }

    @Override
    public void addToEstimate(IDataSequence data) {
        for (IDoubleArray arr : data) {
            double x = arr.get(0);
            this.sumRunning += x;
            this.sumSquaredRunning += x * x;
            this.totalWeightRunning += 1.0;
        }
    }

    @Override
    public void addToEstimate(IDataSequence data, IDoubleArray weights) {
        int i = 0;
        while (i < data.size()) {
            double x = data.get(i).get(0);
            double w = weights.get(i);
            this.sumRunning += w * x;
            this.sumSquaredRunning += w * x * x;
            this.totalWeightRunning += w;
            ++i;
        }
    }

    @Override
    public IDoubleArray getEstimate() {
        double mean = this.sumRunning / this.totalWeightRunning;
        double var = this.sumSquaredRunning / this.totalWeightRunning - mean * mean;
        return Doubles.create.arrayFrom(mean, var);
    }

    @Override
    public GaussianUnivariate copy() {
        return new GaussianUnivariate(this.parameters.get(0), this.parameters.get(1));
    }
}

