/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat;

import stallone.api.API;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;

public class RunningMomentsMultivariate {
    private int dim = 1;
    private int tau = 0;
    private IDoubleArray c;
    private IDoubleArray cc;
    private IDoubleArray cctau;
    private IDoubleArray mean;
    private IDoubleArray Cov;
    private IDoubleArray Covtau;
    private double n = 0.0;

    public RunningMomentsMultivariate(int _dimension) {
        this.dim = _dimension;
        this.c = API.doublesNew.array(this.dim);
        this.cc = API.doublesNew.array(this.dim, this.dim);
        this.mean = API.doublesNew.array(this.dim);
        this.Cov = API.doublesNew.array(this.dim, this.dim);
    }

    public RunningMomentsMultivariate(int _dimension, int _tau) {
        this(_dimension);
        this.tau = _tau;
        this.cctau = API.doublesNew.array(this.dim, this.dim);
        this.Covtau = API.doublesNew.array(this.dim, this.dim);
    }

    public final void addData(IDataSequence data) {
        int j;
        int i;
        if (data.dimension() != this.dim) {
            throw new IllegalArgumentException("Data has incompatible dimension " + data.dimension() + ". Expected " + this.dim);
        }
        double m = data.size();
        this.c.zero();
        for (IDoubleArray[] x : data) {
            i = 0;
            while (i < this.dim) {
                this.c.set(i, this.c.get(i) + x.get(i));
                ++i;
            }
        }
        this.mean = API.alg.addWeightedToNew(this.n / (this.n + m), this.mean, 1.0 / (this.n + m), this.c);
        this.cc.zero();
        for (IDoubleArray[] x : data) {
            i = 0;
            while (i < this.dim) {
                x.set(i, x.get(i) - this.mean.get(i));
                ++i;
            }
            i = 0;
            while (i < this.dim) {
                j = i;
                while (j < this.dim) {
                    double xij = x.get(i) * x.get(j);
                    this.cc.set(i, j, this.cc.get(i, j) + xij);
                    this.cc.set(j, i, this.cc.get(i, j));
                    ++j;
                }
                ++i;
            }
        }
        this.Cov = API.alg.addWeightedToNew(this.n / (this.n + m), this.Cov, 1.0 / (this.n + m), this.cc);
        if (this.cctau != null) {
            this.cctau.zero();
            for (IDoubleArray[] x : data.pairs(this.tau)) {
                i = 0;
                while (i < this.dim) {
                    x[0].set(i, x[0].get(i) - this.mean.get(i));
                    x[1].set(i, x[1].get(i) - this.mean.get(i));
                    ++i;
                }
                i = 0;
                while (i < this.dim) {
                    j = i;
                    while (j < this.dim) {
                        this.cctau.set(i, j, this.cctau.get(i, j) + x[0].get(i) * x[1].get(j));
                        this.cctau.set(j, i, this.cctau.get(j, i) + x[0].get(j) * x[1].get(i));
                        ++j;
                    }
                    ++i;
                }
            }
            this.Covtau = API.alg.addWeightedToNew(this.n / (this.n + m), this.Covtau, 1.0 / (this.n + m), this.cctau);
        }
        this.n += m;
    }

    public IDoubleArray getMean() {
        return this.mean;
    }

    public IDoubleArray getCov() {
        return this.Cov;
    }

    public IDoubleArray getCovLagged() {
        return this.Covtau;
    }

    public int getNumberOfSamples() {
        return (int)this.n;
    }
}

