/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat.modelselection;

import stallone.api.API;
import stallone.api.doubles.IDoubleList;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.stat.modelselection.ExitTimes;

public class ExitTimeSplitter {
    public static boolean VERBOSE = false;
    private double splitAt = 1.5;
    private int nburnin = 1000;
    private int nsample = 100000;
    private IIntList states = API.intsNew.list(0);
    private IDoubleList exitTimes = API.doublesNew.list(0);
    private double[][] exitTimesByState;
    private int[][] exitTimeIndexesByState;
    private ExitTimes[] et;
    private double[] populatedStates;
    private boolean[] isStateSplit;
    private int[] newStates;
    private double[][] splittingParameters;

    public ExitTimeSplitter(int _nburnin, int _nsample) {
        this.nburnin = _nburnin;
        this.nsample = _nsample;
    }

    public ExitTimeSplitter() {
    }

    public void add(int state, double lifetime) {
        this.states.append(state);
        this.exitTimes.append(lifetime);
    }

    public void setSplitAt(double _splitAt) {
        this.splitAt = _splitAt;
    }

    public int getNsamples(int i) {
        if (this.exitTimesByState[i].length > 10000) {
            return 10000;
        }
        if (this.exitTimesByState[i].length > 1000) {
            return 100000;
        }
        return 1000000;
    }

    public void run() {
        int nstates = API.ints.max(this.states) + 1;
        this.populatedStates = new double[nstates];
        this.exitTimesByState = new double[nstates][];
        this.exitTimeIndexesByState = new int[nstates][];
        this.isStateSplit = new boolean[nstates];
        this.splittingParameters = new double[nstates][3];
        this.et = new ExitTimes[nstates];
        this.newStates = this.states.copy().getArray();
        int nstatesAfterSplit = nstates;
        int i = 0;
        while (i < nstates) {
            IIntList I = API.ints.findAll((IIntArray)this.states, i);
            this.exitTimeIndexesByState[i] = I.getArray();
            this.exitTimesByState[i] = API.doubles.subToNew(this.exitTimes, I).getArray();
            if (this.exitTimesByState[i].length > 1) {
                this.et[i] = new ExitTimes(this.exitTimesByState[i]);
                this.et[i].run(this.nburnin, this.getNsamples(i));
                this.isStateSplit[i] = this.et[i].getNumberOfStates() > this.splitAt;
                this.populatedStates[i] = this.et[i].getNumberOfStates();
                if (this.isStateSplit[i]) {
                    double k2;
                    double k1;
                    double a;
                    int state1 = i;
                    int state2 = nstatesAfterSplit;
                    double[] par = this.et[i].getMeanK2();
                    this.splittingParameters[i][0] = a = par[0];
                    this.splittingParameters[i][1] = k1 = par[1];
                    this.splittingParameters[i][2] = k2 = par[2];
                    int j = 0;
                    while (j < this.exitTimesByState[i].length) {
                        this.newStates[this.exitTimeIndexesByState[i][j]] = a * k1 * Math.exp(-k1 * this.exitTimesByState[i][j]) < (1.0 - a) * k2 * Math.exp(-k2 * this.exitTimesByState[i][j]) ? state1 : state2;
                        ++j;
                    }
                    ++nstatesAfterSplit;
                } else {
                    this.splittingParameters[i][0] = 1.0;
                    this.splittingParameters[i][1] = this.et[i].getMeanK();
                }
            }
            ++i;
        }
        if (VERBOSE) {
            this.printResult();
        }
    }

    public boolean hasAnySplits() {
        boolean res = false;
        int i = 0;
        while (i < this.isStateSplit.length) {
            if (this.isStateSplit[i]) {
                res = true;
            }
            ++i;
        }
        return res;
    }

    public boolean isSplit(int oldStateIndex) {
        return this.isStateSplit[oldStateIndex];
    }

    public int[] getNewStateAssignment() {
        return this.newStates;
    }

    public double[] getSplittingParameters(int state) {
        return this.splittingParameters[state];
    }

    public void printResult() {
        System.out.println("state\tevents\tsamples\tnstates\tsplit?\tamplitude\trate k1\trate k2");
        int i = 0;
        while (i < this.isStateSplit.length) {
            System.out.println(String.valueOf(i) + "\t" + this.exitTimesByState[i].length + "\t" + this.getNsamples(i) + "\t" + this.populatedStates[i] + "\t" + this.isStateSplit[i] + "\t" + this.splittingParameters[i][0] + "\t" + this.splittingParameters[i][1] + "\t" + this.splittingParameters[i][2]);
            ++i;
        }
    }
}

