/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat.modelselection;

import stallone.doubles.PrimitiveDoubleTools;
import stallone.ints.PrimitiveIntTools;
import stallone.stat.modelselection.ExitTimes;

public class Merger {
    private double[][] exitTimes;
    private double[][] numberOfStates;

    public Merger(double[][] _exitTimes, int _nburnin, int _nsample) {
        this.exitTimes = _exitTimes;
        this.run(_nburnin, _nsample);
    }

    public Merger(double[][] _exitTimes) {
        this.exitTimes = _exitTimes;
        this.run(1000, 10000);
    }

    private void run(int _nburnin, int _nsample) {
        int i = 1;
        while (i < this.exitTimes.length) {
            int j = i + 1;
            while (j < this.exitTimes.length) {
                double[] timesij = PrimitiveDoubleTools.concat(this.exitTimes[i], this.exitTimes[j]);
                ExitTimes et = new ExitTimes(timesij);
                et.run(_nburnin, _nsample);
                this.numberOfStates[i][j] = et.getNumberOfStates();
                this.numberOfStates[j][i] = et.getNumberOfStates();
                ++j;
            }
            ++i;
        }
    }

    public boolean hasMerged() {
        int i = 1;
        while (i < this.numberOfStates.length) {
            int j = i + 1;
            while (j < this.numberOfStates.length) {
                if (this.numberOfStates[i][j] < 1.5) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private int findSet(int[][] sets, int state) {
        int i = 0;
        while (i < sets.length) {
            if (PrimitiveIntTools.contains(sets[i], state)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[][] getMerge() {
        double[] nstatesLin = new double[this.numberOfStates.length * (this.numberOfStates.length - 1) / 2];
        int k = 0;
        int i = 1;
        while (i < this.numberOfStates.length) {
            int j = i + 1;
            while (j < this.numberOfStates.length) {
                nstatesLin[k++] = this.numberOfStates[i][j];
                ++j;
            }
            ++i;
        }
        int[] I = PrimitiveDoubleTools.sortedIndexes(nstatesLin);
        int[][] sets = new int[this.numberOfStates.length][1];
        int i2 = 0;
        while (i2 < sets.length) {
            sets[i2][0] = i2;
            ++i2;
        }
        i2 = 0;
        while (i2 < I.length) {
            if (nstatesLin[i2] >= 1.5) {
                return sets;
            }
            int state1 = i2 / this.numberOfStates.length;
            int state2 = i2 % this.numberOfStates.length;
            int set1 = this.findSet(sets, state1);
            int set2 = this.findSet(sets, state2);
            boolean merge = true;
            int j1 = 0;
            while (j1 < sets[set1].length) {
                int j2 = 0;
                while (j2 < sets[set2].length) {
                    if (this.numberOfStates[sets[set1][j1]][sets[set2][j2]] >= 1.5) {
                        merge = false;
                    }
                    ++j2;
                }
                ++j1;
            }
            if (merge) {
                sets[set1] = PrimitiveIntTools.concat(sets[set1], sets[set2]);
                sets = PrimitiveIntTools.removeByIndex(sets, set2);
            }
            ++i2;
        }
        return sets;
    }
}

