/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import stallone.util.Command;
import stallone.util.StringTools;

class IntArrayCommand
extends Command {
    int minValue;
    int maxValue;
    int[] value;

    public IntArrayCommand(String cmd, boolean _mandatory, int[] _defaultValue, int _minValue, int _maxValue) {
        super(cmd, _mandatory);
        this.value = _defaultValue;
        this.minValue = _minValue;
        this.maxValue = _maxValue;
        if (_defaultValue != null) {
            int[] nArray = _defaultValue;
            int n = _defaultValue.length;
            int n2 = 0;
            while (n2 < n) {
                int dv = nArray[n2];
                if (this.minValue > dv || dv > this.maxValue) {
                    throw new IllegalArgumentException("Default value " + _defaultValue + " of integer argument " + cmd + " is out of range [" + _minValue + "," + _maxValue + "]");
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean parse() {
        String[] argsFound = this.args.getArguments(this.command);
        this.value = new int[argsFound.length];
        int i = 0;
        while (i < argsFound.length) {
            if (!StringTools.isInt(argsFound[i])) {
                System.out.println("Command -" + this.command + " has unexpected argument: " + argsFound[i] + ". Expect an integer value");
            }
            this.value[i] = StringTools.toInt(argsFound[i]);
            if (this.minValue > this.value[i] || this.value[i] > this.maxValue) {
                System.out.println("Command -" + this.command + " has unexpected argument value: " + this.value + ". Expecting an integer in the range [" + this.minValue + "," + this.maxValue + "]");
            }
            ++i;
        }
        return true;
    }

    public int[] getValue() {
        return this.value;
    }
}

