/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import stallone.util.Arguments;
import stallone.util.ExpectedArgument;
import stallone.util.StringTools;

class StringArgument
extends ExpectedArgument {
    String[] options;
    String value;

    public StringArgument(String cmd, int pos, boolean _mandatory, String defaultValue, String[] _options) {
        super(cmd, pos, _mandatory);
        this.value = defaultValue;
        this.options = _options;
    }

    @Override
    public boolean parseWhenAvailable(Arguments args) {
        if (this.options != null) {
            this.value = args.getArgument(this.command, this.position);
            if (!StringTools.contains(this.options, this.value)) {
                System.out.println("Command -" + this.command + " has unexpected argument: " + this.value + ". Expected arguments are: { " + StringTools.toString(this.options, ", ") + " }");
            }
            return true;
        }
        this.value = args.getArgument(this.command, this.position);
        return true;
    }
}

