/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.algebra.INorm;
import stallone.api.complex.IComplexArray;
import stallone.api.complex.IComplexIterator;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.complex.ComplexNumber;

public class ArrayNorm
implements INorm {
    @Override
    public double norm(IDoubleArray v) {
        return this.norm(v, 2);
    }

    @Override
    public double norm(IDoubleArray v, int p) {
        double sum = 0.0;
        double abs = 0.0;
        IDoubleIterator it = v.nonzeroIterator();
        while (it.hasNext()) {
            abs = it.get();
            sum += Math.pow(abs, p);
            it.advance();
        }
        return Math.pow(sum, 1.0 / (double)p);
    }

    @Override
    public double norm(IComplexArray v) {
        return this.norm(v, 2);
    }

    @Override
    public double norm(IComplexArray v, int p) {
        double sum = 0.0;
        ComplexNumber o1 = ComplexNumber.createZero();
        double abs = 0.0;
        IComplexIterator it = v.nonzeroComplexIterator();
        while (it.hasNext()) {
            o1.setComplex(it.getRe(), it.getIm());
            abs = o1.abs();
            sum += Math.pow(abs, p);
            it.advance();
        }
        return sum;
    }
}

