/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.complex.IComplexArray;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.DoubleArrayTest;

public class ArrayTranspose {
    public IDoubleArray transposeToNew(IDoubleArray a) {
        IDoubleArray res = a.create(a.columns(), a.rows());
        this.transpose(a, res);
        return res;
    }

    public void transpose(IDoubleArray a, IDoubleArray target) {
        int rows = target.rows();
        int cols = target.columns();
        DoubleArrayTest.assertRows(target, a.columns());
        DoubleArrayTest.assertColumns(target, a.rows());
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                target.set(i, j, a.get(j, i));
                ++j;
            }
            ++i;
        }
    }

    public void transpose(IDoubleArray a) {
        int rows = a.rows();
        int cols = a.columns();
        DoubleArrayTest.assertSquare(a);
        int i = 0;
        while (i < rows) {
            int j = i;
            while (j < cols) {
                double h = a.get(i, j);
                a.set(i, j, a.get(j, i));
                a.set(j, i, h);
                ++j;
            }
            ++i;
        }
    }

    public IComplexArray conjugateTransposeToNew(IComplexArray a) {
        IComplexArray res = a.create(a.columns(), a.rows());
        this.transpose(a, res);
        return res;
    }

    public void conjugateTranspose(IComplexArray a, IComplexArray target) {
        int rows = target.rows();
        int cols = target.columns();
        DoubleArrayTest.assertRows(target, a.columns());
        DoubleArrayTest.assertColumns(target, a.rows());
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                target.setRe(i, j, a.getRe(j, i));
                target.setIm(i, j, -a.getIm(j, i));
                ++j;
            }
            ++i;
        }
    }

    public void conjugateTranspose(IComplexArray a) {
        int rows = a.rows();
        int cols = a.columns();
        DoubleArrayTest.assertSquare(a);
        int i = 0;
        while (i < rows) {
            int j = i;
            while (j < cols) {
                double hre = a.getRe(i, j);
                double him = a.getIm(i, j);
                a.set(i, j, a.getRe(j, i), a.getIm(j, i));
                a.set(j, i, hre, him);
                ++j;
            }
            ++i;
        }
    }
}

