/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra.extern;

import java.util.logging.Level;
import java.util.logging.Logger;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.BiCG;
import no.uib.cipr.matrix.sparse.CG;
import no.uib.cipr.matrix.sparse.DefaultIterationMonitor;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;
import no.uib.cipr.matrix.sparse.SparseVector;
import stallone.api.algebra.ILinearSystem;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.mtj.WrappedMTJMatrix;
import stallone.doubles.mtj.WrappedMTJVector;

public class RealSparseLinearSystem
implements ILinearSystem {
    public static final int BiCGstab = 1;
    public static final int BiCG = 2;
    public static final int CG = 3;
    public static final int CGS = 4;
    private IDoubleArray wrappedLeftSideMatrix;
    private IDoubleArray wrappedCoefficientVector;
    private IDoubleArray wrappedSolutionVector;
    private AbstractIterativeSolver solver;
    private Matrix leftSideMatrix;
    private Vector coefficientVector;
    private Vector solutionVector;
    private final int solverType;

    public RealSparseLinearSystem(int solverType) {
        this.solverType = solverType;
    }

    @Override
    public void setMatrix(IDoubleArray A) {
        this.leftSideMatrix = new FlexCompColMatrix(A.rows(), A.columns());
        this.wrappedLeftSideMatrix = new WrappedMTJMatrix(this.leftSideMatrix);
        this.wrappedLeftSideMatrix.copyFrom(A);
    }

    @Override
    public void setCoefficientVector(IDoubleArray b) {
        this.coefficientVector = new SparseVector(b.size());
        this.wrappedCoefficientVector = new WrappedMTJVector(this.coefficientVector);
        this.wrappedCoefficientVector.copyFrom(b);
        this.solutionVector = new SparseVector(b.size());
        this.wrappedSolutionVector = new WrappedMTJVector(this.solutionVector);
    }

    @Override
    public void perform() {
        try {
            if (this.solverType == 3) {
                this.solver = new CG(this.solutionVector);
            } else if (this.solverType == 2) {
                this.solver = new BiCG(this.solutionVector);
            }
            DefaultIterationMonitor monitor = new DefaultIterationMonitor();
            monitor.setMaxIterations(1000000);
            this.solver.setIterationMonitor(monitor);
            this.solver.solve(this.leftSideMatrix, this.coefficientVector, this.solutionVector);
        }
        catch (IterativeSolverNotConvergedException ex) {
            System.out.println("Iteration did not converge!!!");
            Logger.getLogger(RealSparseLinearSystem.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public IDoubleArray getSolutionVector() {
        return this.wrappedSolutionVector;
    }
}

