/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.algebra;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import stallone.algebra.RealCholeskyDecomposition;
import stallone.algebra.RealLUDecomposition;
import stallone.algebra.RealLinearSystem;
import stallone.algebra.RealQRDecomposition;
import stallone.algebra.extern.LapackEigenvalueDecomposition;
import stallone.algebra.extern.RealSparseLinearSystem;
import stallone.algebra.extern.SparseArpackEigenvalueDecomposition;
import stallone.api.algebra.ICholeskyDecomposition;
import stallone.api.algebra.IEigenvalueSolver;
import stallone.api.algebra.ILUDecomposition;
import stallone.api.algebra.ILinearMatrixSystem;
import stallone.api.algebra.ILinearSystem;
import stallone.api.algebra.IQRDecomposition;
import stallone.api.doubles.IDoubleArray;

public class AlgebraFactory {
    public ILinearSystem linearSolver(IDoubleArray A, IDoubleArray b) {
        RealLinearSystem system = new RealLinearSystem();
        system.setCoefficientVector(b);
        system.setMatrix(A);
        return system;
    }

    public List<String> queryLinearSolverNames() {
        return AlgebraFactory.getNames(LinearSystemEnum.values());
    }

    public ILinearMatrixSystem linearMatrixSolver(IDoubleArray A, IDoubleArray B) {
        RealLinearSystem system = new RealLinearSystem();
        system.setCoefficientMatrix(B);
        system.setMatrix(A);
        return system;
    }

    public ILinearSystem linearSolver(IDoubleArray A, IDoubleArray b, String algoName) {
        ILinearSystem linearSystem = null;
        if (algoName.equals(LinearSystemEnum.DENSE_QR.name())) {
            linearSystem = new RealLinearSystem();
        } else if (algoName.equals(LinearSystemEnum.SPARSE_MTJ_CG.name())) {
            linearSystem = new RealSparseLinearSystem(3);
        } else if (algoName.equals(LinearSystemEnum.SPARSE_MTJ_BiCG.name())) {
            linearSystem = new RealSparseLinearSystem(2);
        }
        if (linearSystem == null) {
            String message = "Requested linear solver '" + algoName + "' is not available, " + "only " + AlgebraFactory.concatenate(this.queryLinearSolverNames(), ", ") + " available.";
            throw new UnsupportedOperationException(message);
        }
        linearSystem.setMatrix(A);
        linearSystem.setCoefficientVector(b);
        return linearSystem;
    }

    public ILUDecomposition LUSolver(IDoubleArray A) {
        RealLUDecomposition decomposition = new RealLUDecomposition();
        decomposition.setMatrix(A);
        return decomposition;
    }

    public IQRDecomposition QRSolver(IDoubleArray A) {
        RealQRDecomposition decomposition = new RealQRDecomposition();
        decomposition.setMatrix(A);
        return decomposition;
    }

    public IEigenvalueSolver eigensolver(IDoubleArray matrix, int nev) {
        if (matrix.isSparse() && 10 * nev < matrix.size()) {
            return this.eigensolverSparse(matrix, nev);
        }
        return this.eigensolverDense(matrix);
    }

    public IEigenvalueSolver eigensolverSparse(IDoubleArray matrix, int n) {
        SparseArpackEigenvalueDecomposition solver = new SparseArpackEigenvalueDecomposition(matrix);
        solver.setNumberOfRequestedEigenvalues(n);
        return solver;
    }

    public IEigenvalueSolver eigensolverDense(IDoubleArray matrix) {
        LapackEigenvalueDecomposition blas = new LapackEigenvalueDecomposition();
        blas.setMatrix(matrix);
        return blas;
    }

    public IEigenvalueSolver eigensolverDense(IDoubleArray matrix, boolean computeLeftEV, boolean computeRightEV) {
        LapackEigenvalueDecomposition blas = new LapackEigenvalueDecomposition(computeLeftEV, computeRightEV);
        blas.setMatrix(matrix);
        return blas;
    }

    public IEigenvalueSolver eigensolver(IDoubleArray matrix, String algoName) {
        if (algoName.equals(EigenvalueDecompositionEnum.DENSE_BLAS.name())) {
            return new LapackEigenvalueDecomposition();
        }
        if (algoName.equals(EigenvalueDecompositionEnum.SPARSE_ARPACK.name())) {
            return new SparseArpackEigenvalueDecomposition(matrix);
        }
        String message = "Requested eigenvalue decomposition '" + algoName + "' is not available, " + "only " + AlgebraFactory.concatenate(this.queryEigenvalueDecompositionNames(), ", ") + " available.";
        throw new UnsupportedOperationException(message);
    }

    public List<String> queryEigenvalueDecompositionNames() {
        return AlgebraFactory.getNames(EigenvalueDecompositionEnum.values());
    }

    public static List<String> getNames(Enum<?>[] enums) {
        ArrayList<String> names = new ArrayList<String>();
        Enum<?>[] enumArray = enums;
        int n = enums.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> enumeration = enumArray[n2];
            names.add(enumeration.name());
            ++n2;
        }
        return names;
    }

    protected static String concatenate(List<String> strings, String delim) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            String string = it.next();
            builder.append(string);
            if (!it.hasNext()) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public ICholeskyDecomposition createCholeskyDecomposition(IDoubleArray matrix) {
        return new RealCholeskyDecomposition(matrix);
    }

    public static enum EigenvalueDecompositionEnum {
        DENSE_BLAS(true),
        SPARSE_ARPACK(false);

        protected boolean dense;

        private EigenvalueDecompositionEnum(boolean dense) {
            this.dense = dense;
        }

        public boolean isDense() {
            return this.dense;
        }
    }

    public static enum LinearSystemEnum {
        DENSE_QR(true),
        SPARSE_MTJ_CG(false),
        SPARSE_MTJ_BiCG(false);

        protected boolean dense;

        private LinearSystemEnum(boolean dense) {
            this.dense = dense;
        }

        public boolean isDense() {
            return this.dense;
        }
    }
}

