/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.coordinates;

import java.io.IOException;
import stallone.api.API;
import stallone.api.coordinates.CoordinateUtilities3D;
import stallone.api.coordinates.ICoordinateTransform;
import stallone.api.datasequence.IDataReader;
import stallone.api.datasequence.IDataSequence;
import stallone.api.datasequence.IDataWriter;
import stallone.api.doubles.IDoubleArray;
import stallone.coordinates.MinimalRMSDistance3D;
import stallone.datasequence.io.AsciiDataSequenceWriter;

public class CoordinateUtilities {
    private MinimalRMSDistance3D minrmsd = null;
    private boolean fixedOutputPrecision = false;
    private int outputPrecisionPre = 5;
    private int outputPrecisionPost = 3;
    private double[] v1 = new double[]{0.0, 0.0, 0.0};
    private double[] v2 = new double[]{0.0, 0.0, 0.0};
    private double rad2deg = 57.29577951308232;
    private boolean degrees = true;

    public void transform_file(String infile, ICoordinateTransform T, String outfile) throws IOException {
        IDataReader reader = API.dataNew.reader(infile);
        int N = reader.size();
        IDataWriter writer = API.dataNew.writer(outfile, N, T.dimension());
        if (writer instanceof AsciiDataSequenceWriter && this.fixedOutputPrecision) {
            ((AsciiDataSequenceWriter)writer).setFixedPrecision(this.outputPrecisionPre, this.outputPrecisionPost);
        }
        for (IDoubleArray X : reader) {
            writer.add(T.transform(X));
        }
        writer.close();
    }

    private double dotprod(IDoubleArray X, int i, int j) {
        return X.get(i, 0) * X.get(j, 0) + X.get(i, 1) * X.get(j, 1) + X.get(i, 2) * X.get(j, 2);
    }

    public void vector(IDoubleArray X, int i, int j, double[] v) {
        v[0] = X.get(j, 0) - X.get(i, 0);
        v[1] = X.get(j, 1) - X.get(i, 1);
        v[2] = X.get(j, 2) - X.get(i, 2);
    }

    public double[] vector(IDoubleArray X, int i, int j) {
        double[] v = new double[3];
        this.vector(X, i, j, v);
        return v;
    }

    public double squaredistance(IDoubleArray X, int i, int j) {
        this.vector(X, i, j, this.v1);
        return this.v1[0] * this.v1[0] + this.v1[1] * this.v1[1] + this.v1[2] * this.v1[2];
    }

    public double distance(IDoubleArray X, int i, int j) {
        return Math.sqrt(this.squaredistance(X, i, j));
    }

    public double angleRad(IDoubleArray X, int i, int j, int k) {
        this.vector(X, j, i, this.v1);
        this.vector(X, j, k, this.v2);
        return CoordinateUtilities3D.angleRad(this.v1, this.v2);
    }

    public double angleDeg(IDoubleArray X, int i, int j, int k) {
        return this.rad2deg * this.angleRad(X, i, j, k);
    }

    public double torsionRad(IDoubleArray X, int p1, int p2, int p3, int p4) {
        this.vector(X, p2, p1, this.v1);
        this.vector(X, p2, p3, this.v2);
        double[] cv1 = CoordinateUtilities3D.crossprod(this.v1, this.v2);
        this.vector(X, p3, p2, this.v1);
        this.vector(X, p3, p4, this.v2);
        double[] cv2 = CoordinateUtilities3D.crossprod(this.v1, this.v2);
        double angle = CoordinateUtilities3D.angleRad(cv1, cv2);
        if (CoordinateUtilities3D.dotprod(this.v2, cv1) > 0.0) {
            angle = -angle;
        }
        return angle;
    }

    public double torsionDeg(IDoubleArray X, int p1, int p2, int p3, int p4) {
        return this.rad2deg * this.torsionRad(X, p1, p2, p3, p4);
    }

    public IDataSequence transform_data(IDataSequence X, ICoordinateTransform T) {
        IDoubleArray[] res = new IDoubleArray[X.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = T.transform(X.get(i));
            ++i;
        }
        return API.dataNew.array(res);
    }

    public void fixOutputPrecision(int pre, int post) {
        this.fixedOutputPrecision = true;
        this.outputPrecisionPre = pre;
        this.outputPrecisionPost = post;
    }

    public void fixOutputPrecision() {
        this.fixedOutputPrecision = false;
    }

    public double minRMSD(IDoubleArray x1, IDoubleArray x2) {
        int N = x1.rows();
        if (this.minrmsd == null) {
            this.minrmsd = new MinimalRMSDistance3D(N);
        }
        if (this.minrmsd.getN() != N) {
            this.minrmsd = new MinimalRMSDistance3D(N);
        }
        return this.minrmsd.distance(x1, x2);
    }

    public IDoubleArray distances(IDoubleArray x, int[] set) {
        IDoubleArray res = API.doublesNew.array(set.length * (set.length - 1) / 2);
        this.distances(x, set, res);
        return res;
    }

    public void distances(IDoubleArray x, int[] set, IDoubleArray out) {
        int n = set.length;
        if (out.size() != n * (n - 1) / 2) {
            throw new IllegalArgumentException("target array has illegal size " + out.size() + ". requiring " + (n * n - 1) / 2);
        }
        int p = 0;
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                out.set(p++, this.distance(x, set[i], set[j]));
                ++j;
            }
            ++i;
        }
    }

    public IDoubleArray distances(IDoubleArray x, int[][] set) {
        IDoubleArray res = API.doublesNew.array(set.length * (set.length - 1) / 2);
        this.distances(x, set, res);
        return res;
    }

    public void distances(IDoubleArray x, int[][] set, IDoubleArray out) {
        int n = set.length;
        if (out.size() != n * (n - 1) / 2) {
            throw new IllegalArgumentException("target array has illegal size " + out.size() + ". requiring " + (n * n - 1) / 2);
        }
        int p = 0;
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                double dmin = Double.POSITIVE_INFINITY;
                int ni = set[i].length;
                int nj = set[j].length;
                int k = 0;
                while (k < ni) {
                    int l = 0;
                    while (l < nj) {
                        double d = this.distance(x, set[i][k], set[j][l]);
                        if (d < dmin) {
                            dmin = d;
                        }
                        ++l;
                    }
                    ++k;
                }
                out.set(p++, dmin);
                ++j;
            }
            ++i;
        }
    }

    public IDoubleArray distanceMatrix(IDoubleArray x, int[] set) {
        IDoubleArray res = API.doublesNew.array(set.length, set.length);
        this.distanceMatrix(x, set, res);
        return res;
    }

    public void distanceMatrix(IDoubleArray x, int[] set, IDoubleArray target) {
        int n = set.length;
        if (target.rows() != n && target.columns() != n) {
            throw new IllegalArgumentException("target array has illegal size (" + target.rows() + "," + target.columns() + "). requiring (" + n + "," + n + ")");
        }
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                double dij = this.distance(x, set[i], set[j]);
                target.set(i, j, dij);
                target.set(j, i, dij);
                ++j;
            }
            ++i;
        }
    }

    public IDoubleArray distanceMatrix(IDoubleArray x, int[][] set) {
        IDoubleArray res = API.doublesNew.array(set.length, set.length);
        this.distanceMatrix(x, set, res);
        return res;
    }

    public void distanceMatrix(IDoubleArray x, int[][] set, IDoubleArray target) {
        int n = set.length;
        if (target.rows() != n && target.columns() != n) {
            throw new IllegalArgumentException("target array has illegal size (" + target.rows() + "," + target.columns() + "). requiring (" + n + "," + n + ")");
        }
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                double dmin = Double.POSITIVE_INFINITY;
                int ni = set[i].length;
                int nj = set[j].length;
                int k = 0;
                while (k < ni) {
                    int l = 0;
                    while (l < nj) {
                        double d = this.distance(x, set[i][k], set[j][l]);
                        if (d < dmin) {
                            dmin = d;
                        }
                        ++l;
                    }
                    ++k;
                }
                target.set(i, j, dmin);
                target.set(j, i, dmin);
                ++j;
            }
            ++i;
        }
    }

    public IDoubleArray distanceMatrix(IDoubleArray x, int[] set1, int[] set2) {
        IDoubleArray res = API.doublesNew.array(set1.length, set2.length);
        this.distanceMatrix(x, set1, set2, res);
        return res;
    }

    public void distanceMatrix(IDoubleArray x, int[] set1, int[] set2, IDoubleArray target) {
        int m = set1.length;
        int n = set2.length;
        if (target.rows() != m && target.columns() != n) {
            throw new IllegalArgumentException("target array has illegal size (" + target.rows() + "," + target.columns() + "). requiring (" + m + "," + n + ")");
        }
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                target.set(i, j, this.distance(x, set1[i], set2[j]));
                ++j;
            }
            ++i;
        }
    }

    public IDoubleArray distanceMatrix(IDoubleArray x, int[][] set1, int[][] set2) {
        IDoubleArray res = API.doublesNew.array(set1.length, set2.length);
        this.distanceMatrix(x, set1, set2, res);
        return res;
    }

    public void distanceMatrix(IDoubleArray x, int[][] set1, int[][] set2, IDoubleArray target) {
        int m = set1.length;
        int n = set2.length;
        if (target.rows() != m && target.columns() != n) {
            throw new IllegalArgumentException("target array has illegal size (" + target.rows() + "," + target.columns() + "). requiring (" + m + "," + n + ")");
        }
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                double dmin = Double.POSITIVE_INFINITY;
                int ni = set1[i].length;
                int nj = set2[j].length;
                int k = 0;
                while (k < ni) {
                    int l = 0;
                    while (l < nj) {
                        double d = this.distance(x, set1[i][k], set2[j][l]);
                        if (d < dmin) {
                            dmin = d;
                        }
                        ++l;
                    }
                    ++k;
                }
                target.set(i, j, dmin);
                ++j;
            }
            ++i;
        }
    }

    public void anglesInDegrees() {
        this.degrees = true;
    }

    public void anglesInRadians() {
        this.degrees = false;
    }

    public IDoubleArray angles(IDoubleArray x, int[][] selection) {
        IDoubleArray res = API.doublesNew.array(selection.length);
        this.angles(x, selection, res);
        return res;
    }

    public void angles(IDoubleArray x, int[][] selection, IDoubleArray out) {
        int i = 0;
        while (i < selection.length) {
            if (selection[i].length == 3) {
                if (this.degrees) {
                    out.set(i, this.angleDeg(x, selection[i][0], selection[i][1], selection[i][2]));
                } else {
                    out.set(i, this.angleRad(x, selection[i][0], selection[i][1], selection[i][2]));
                }
            } else if (selection[i].length == 4) {
                if (this.degrees) {
                    out.set(i, this.torsionDeg(x, selection[i][0], selection[i][1], selection[i][2], selection[i][3]));
                } else {
                    out.set(i, this.torsionRad(x, selection[i][0], selection[i][1], selection[i][2], selection[i][3]));
                }
            } else {
                throw new IllegalArgumentException("found a selection with " + selection[i].length + " elements. Can only handle 3 (angles) and 4 (torsions)");
            }
            ++i;
        }
    }

    public void select(IDoubleArray in, int[] selection, IDoubleArray out) {
        int i = 0;
        while (i < selection.length) {
            int j = 0;
            while (j < in.columns()) {
                out.set(i, j, in.get(selection[i], j));
                ++j;
            }
            ++i;
        }
    }
}

