/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.datasequence;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataReader;
import stallone.api.datasequence.IDataSequence;
import stallone.api.datasequence.IDataSequenceLoader;
import stallone.api.datasequence.IDataWriter;
import stallone.api.doubles.IDoubleArray;
import stallone.datasequence.DataArray;
import stallone.datasequence.DataList;
import stallone.datasequence.DataSequenceList;
import stallone.datasequence.DataSequenceLoader_SingleReaderImpl;
import stallone.datasequence.io.AsciiDataSequenceReader;
import stallone.datasequence.io.AsciiDataSequenceWriter;
import stallone.datasequence.io.DataSequenceFileFormats;

public class DataSequenceFactory {
    public IDataSequenceLoader multiSequenceLoader(List<String> files, IDataReader reader) throws IOException {
        DataSequenceLoader_SingleReaderImpl loader = new DataSequenceLoader_SingleReaderImpl(files, reader);
        loader.scan();
        return loader;
    }

    public IDataSequenceLoader multiSequenceLoader(List<String> files) throws IOException {
        IDataReader sequenceLoader = DataSequenceFileFormats.createReader(files.get(0));
        sequenceLoader.scan();
        return this.multiSequenceLoader(files, sequenceLoader);
    }

    public IDataSequenceLoader multiSequenceLoader(String file, IDataReader reader) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        files.add(file);
        return this.multiSequenceLoader(files, reader);
    }

    public IDataSequenceLoader multiSequenceLoader(String file) throws IOException {
        IDataReader reader = DataSequenceFileFormats.createReader(file);
        ArrayList<String> files = new ArrayList<String>();
        files.add(file);
        return this.multiSequenceLoader(files, reader);
    }

    public IDataInput dataInput(List<String> files, IDataReader reader) throws IOException {
        return this.multiSequenceLoader(files, reader);
    }

    public IDataInput dataInput(List data) throws IOException {
        if (data.get(0) instanceof String) {
            return this.multiSequenceLoader(data);
        }
        if (data.get(0) instanceof IDataSequence) {
            DataSequenceList res = new DataSequenceList();
            res.addAll(data);
            return res;
        }
        throw new IllegalArgumentException("Type not supported");
    }

    public IDataInput dataInput(String file) throws IOException {
        return this.multiSequenceLoader(file);
    }

    public IDataInput dataInput(IDataSequence[] data) {
        DataSequenceList res = new DataSequenceList();
        res.addAll(Arrays.asList(data));
        return res;
    }

    public IDataInput dataInput(IDataSequence data) {
        DataSequenceList res = new DataSequenceList();
        res.add(data);
        return res;
    }

    public IDataList list() {
        DataList ds = new DataList();
        return ds;
    }

    public IDataSequence array(int size) {
        DataArray ds = new DataArray(size);
        return ds;
    }

    public IDataSequence array(IDoubleArray[] content) {
        DataArray ds = new DataArray(content);
        return ds;
    }

    public IDataReader reader(String file) throws IOException {
        IDataReader sequenceReader = DataSequenceFileFormats.createReader(file);
        sequenceReader.scan();
        return sequenceReader;
    }

    public IDataReader readerASCII(String file) throws IOException {
        AsciiDataSequenceReader input = new AsciiDataSequenceReader(file);
        return input;
    }

    public IDataWriter writer(String file, int size, int dimension) throws FileNotFoundException, IOException {
        return DataSequenceFileFormats.createWriter(file, size, dimension);
    }

    public IDataWriter writerConsole() {
        AsciiDataSequenceWriter out = new AsciiDataSequenceWriter(System.out);
        return out;
    }

    public IDataWriter writerConsole(String dataDelimiter, String datasetDelimiter) {
        AsciiDataSequenceWriter out = new AsciiDataSequenceWriter(System.out);
        out.setOutputDelimiters(dataDelimiter, datasetDelimiter);
        return out;
    }

    public IDataWriter writerASCII(String file) throws FileNotFoundException {
        AsciiDataSequenceWriter out = new AsciiDataSequenceWriter(file);
        return out;
    }

    public IDataWriter writerASCII(String file, String dataDelimiter, String datasetDelimiter) throws FileNotFoundException {
        AsciiDataSequenceWriter out = new AsciiDataSequenceWriter(file);
        out.setOutputDelimiters(dataDelimiter, datasetDelimiter);
        return out;
    }
}

