/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.discretization;

import stallone.api.datasequence.IDataSequence;
import stallone.api.discretization.IDiscretization;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.api.function.IFunction;
import stallone.api.function.IGriddedFunction;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.cluster.CoreDiscretization;
import stallone.datasequence.DataList;
import stallone.discretization.GriddedFunctionOnDemand;
import stallone.discretization.VoronoiDiscretization;
import stallone.doubles.EuclideanDistance;

public class DiscretizationFactory {
    public IGriddedFunction createGridDiscretization(IFunction _F, IDoubleArray bounds, double boxsize) {
        GriddedFunctionOnDemand g = new GriddedFunctionOnDemand(_F, bounds, boxsize);
        return g;
    }

    public IGriddedFunction createGridDiscretization(IFunction _F, IDoubleArray griddef) {
        GriddedFunctionOnDemand g = new GriddedFunctionOnDemand(_F, griddef);
        return g;
    }

    public IDiscretization voronoiDiscretization(IDataSequence centers, IMetric<IDoubleArray> metric) {
        VoronoiDiscretization vd = new VoronoiDiscretization(centers, metric);
        return vd;
    }

    public IDiscretization voronoiDiscretization(IDataSequence centers) {
        VoronoiDiscretization vd = new VoronoiDiscretization(centers, new EuclideanDistance());
        return vd;
    }

    public IDiscretization coreDiscretization(IDataSequence _centers, double _radius, IMetric<IDoubleArray> _metric) {
        CoreDiscretization disc = new CoreDiscretization(_centers, _radius, _metric);
        return disc;
    }

    public IDiscretization coreDiscretization(IDataSequence _centers, double _radius) {
        CoreDiscretization disc = new CoreDiscretization(_centers, _radius, new EuclideanDistance());
        return disc;
    }

    public IDiscretization regularSelectionDiscretization(IDataSequence data, IMetric<IDoubleArray> metric, int k) {
        DataList clusterCenters = new DataList(k);
        IIntArray indexes = Ints.create.arrayRange(0, data.size(), data.size() / k);
        int i = 0;
        while (i < indexes.size()) {
            clusterCenters.set(i, data.get(indexes.get(i)));
            ++i;
        }
        VoronoiDiscretization vd = new VoronoiDiscretization(clusterCenters, metric);
        return vd;
    }

    public IDiscretization regularSelectionDiscretization(IDataSequence data, int k) {
        return this.regularSelectionDiscretization(data, new EuclideanDistance(), k);
    }

    public IDiscretization randomSelectionDiscretization(IDataSequence data, IMetric<IDoubleArray> metric, int k) {
        DataList clusterCenters = new DataList(k);
        IIntArray indexes = Ints.create.arrayRandomIndexes(data.size(), k);
        int i = 0;
        while (i < indexes.size()) {
            clusterCenters.add(data.get(indexes.get(i)));
            ++i;
        }
        VoronoiDiscretization vd = new VoronoiDiscretization(clusterCenters, metric);
        return vd;
    }

    public IDiscretization randomSelectionDiscretization(IDataSequence data, int k) {
        return this.randomSelectionDiscretization(data, new EuclideanDistance(), k);
    }
}

