/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.ints;

import java.nio.ByteBuffer;
import java.util.Arrays;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.ints.ForeignBufferIntArray;
import stallone.ints.IntArrayList_FastUtilWrapper;
import stallone.ints.PrimitiveIntArray;
import stallone.ints.PrimitiveIntTable;
import stallone.ints.PrimitiveIntTools;

public class IntFactory {
    public IIntArray like(IIntArray arr, int size) {
        return arr.create(size);
    }

    public IIntArray array(int size) {
        return new PrimitiveIntArray(new int[size]);
    }

    public IIntArray array(int size, int value) {
        return new PrimitiveIntArray(PrimitiveIntTools.createInitialized(size, value));
    }

    public IIntArray array(IIntArray arr) {
        return new PrimitiveIntArray(arr.getArray());
    }

    public IIntArray arrayFrom(int d) {
        int[] arr = PrimitiveIntTools.getIntArray(d);
        return new PrimitiveIntArray(arr);
    }

    public IIntArray arrayFrom(int d1, int ... d2) {
        int[] arr = PrimitiveIntTools.concat(PrimitiveIntTools.getIntArray(d1), d2);
        return new PrimitiveIntArray(arr);
    }

    public IIntArray arrayFrom(int[] arr) {
        return new PrimitiveIntArray(arr);
    }

    public IIntArray arrayFrom(double[] a) {
        int[] res = PrimitiveIntTools.from(a);
        return new PrimitiveIntArray(res);
    }

    public IIntArray arrayFrom(float[] a) {
        int[] res = PrimitiveIntTools.from(a);
        return new PrimitiveIntArray(res);
    }

    public IIntArray arrayFrom(ByteBuffer bb, int rows, int cols) {
        return new ForeignBufferIntArray(bb, rows, cols);
    }

    public IIntArray arrayRandomIndexes(int N, int n) {
        int[] res = PrimitiveIntTools.randomIndexes(N, n);
        return new PrimitiveIntArray(res);
    }

    public IIntArray arrayRange(int start, int end, int step) {
        int[] res = PrimitiveIntTools.range(start, end, step);
        return new PrimitiveIntArray(res);
    }

    public IIntArray arrayRange(int start, int end) {
        int[] res = PrimitiveIntTools.range(start, end);
        return new PrimitiveIntArray(res);
    }

    public IIntArray arrayRange(int end) {
        int[] res = PrimitiveIntTools.range(end);
        return new PrimitiveIntArray(res);
    }

    public IIntList list(int size) {
        return new IntArrayList_FastUtilWrapper(new int[size]);
    }

    public IIntList list(int size, int value) {
        return new IntArrayList_FastUtilWrapper(PrimitiveIntTools.createInitialized(size, value));
    }

    public IIntList list(IIntArray arr) {
        return new IntArrayList_FastUtilWrapper(arr.getArray());
    }

    public IIntList listFrom(int d) {
        int[] arr = PrimitiveIntTools.getIntArray(d);
        return new IntArrayList_FastUtilWrapper(arr);
    }

    public IIntList listFrom(int d1, int ... d2) {
        int[] arr = PrimitiveIntTools.concat(PrimitiveIntTools.getIntArray(d1), d2);
        return new IntArrayList_FastUtilWrapper(arr);
    }

    public IIntList listFrom(int[] arr) {
        return new IntArrayList_FastUtilWrapper(arr);
    }

    public IIntList listFrom(double[] a) {
        int[] res = PrimitiveIntTools.from(a);
        return new IntArrayList_FastUtilWrapper(res);
    }

    public IIntList listFrom(float[] a) {
        int[] res = PrimitiveIntTools.from(a);
        return new IntArrayList_FastUtilWrapper(res);
    }

    public IIntList listRandomIndexes(int N, int n) {
        int[] res = PrimitiveIntTools.randomIndexes(N, n);
        return new IntArrayList_FastUtilWrapper(res);
    }

    public IIntList listRange(int start, int end, int step) {
        int[] res = PrimitiveIntTools.range(start, end, step);
        return new IntArrayList_FastUtilWrapper(res);
    }

    public IIntList listRange(int start, int end) {
        int[] res = PrimitiveIntTools.range(start, end);
        return new IntArrayList_FastUtilWrapper(res);
    }

    public IIntList listRange(int end) {
        int[] res = PrimitiveIntTools.range(end);
        return new IntArrayList_FastUtilWrapper(res);
    }

    public IIntArray table(int[][] a) {
        return new PrimitiveIntTable(a);
    }

    public IIntArray table(int nrows, int ncols) {
        return new PrimitiveIntTable(new int[nrows][ncols]);
    }

    public IIntArray table(int nrows, int ncols, int value) {
        int[][] arr = new int[nrows][ncols];
        int i = 0;
        while (i < nrows) {
            Arrays.fill(arr[i], value);
            ++i;
        }
        return new PrimitiveIntTable(arr);
    }

    public IIntArray tableFrom(float[][] a) {
        int[][] res = new int[a.length][];
        int i = 0;
        while (i < a.length) {
            res[i] = new int[a[i].length];
            int j = 0;
            while (j < a[i].length) {
                res[i][j] = (int)a[i][j];
                ++j;
            }
            ++i;
        }
        return new PrimitiveIntTable(res);
    }

    public IIntArray tableFrom(double[][] a) {
        int[][] res = new int[a.length][];
        int i = 0;
        while (i < a.length) {
            res[i] = new int[a[i].length];
            int j = 0;
            while (j < a[i].length) {
                res[i][j] = (int)a[i][j];
                ++j;
            }
            ++i;
        }
        return new PrimitiveIntTable(res);
    }

    public IIntArray tableReshape(IIntArray arr, int d1, int d2) {
        if (arr.size() != d1 * d2) {
            throw new IllegalArgumentException("Illegal array size");
        }
        IIntArray res = this.table(d1, d2);
        int i = 0;
        while (i < d1) {
            int j = 0;
            while (j < d2) {
                res.set(i, j, arr.get(i * d2 + j));
                ++j;
            }
            ++i;
        }
        return res;
    }
}

