/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.mc;

import stallone.api.algebra.Algebra;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.api.function.IGriddedFunction;
import stallone.api.ints.IIntArray;
import stallone.api.mc.ICountMatrixEstimator;
import stallone.api.mc.IDeltaGDistribution;
import stallone.api.mc.IDynamicalExpectations;
import stallone.api.mc.IDynamicalExpectationsSpectral;
import stallone.api.mc.IMarkovChain;
import stallone.api.mc.ITransitionMatrixEstimator;
import stallone.api.mc.ITransitionMatrixSampler;
import stallone.api.mc.MarkovModel;
import stallone.api.mc.tpt.ICommittor;
import stallone.api.mc.tpt.ITPTFlux;
import stallone.mc.DiscretePotentialMetropolisMarkovChain;
import stallone.mc.MarkovChain;
import stallone.mc.PosteriorCountMatrix;
import stallone.mc.correlations.DynamicalExpectations;
import stallone.mc.correlations.DynamicalExpectationsSpectral;
import stallone.mc.estimator.CountMatrixEstimatorSliding;
import stallone.mc.estimator.CountMatrixEstimatorStepping;
import stallone.mc.estimator.TransitionMatrixEstimatorNonRev;
import stallone.mc.estimator.TransitionMatrixEstimatorRev;
import stallone.mc.estimator.TransitionMatrixEstimatorRevFixPi;
import stallone.mc.pcca.PCCA;
import stallone.mc.sampling.DeltaGGaussian;
import stallone.mc.sampling.TransitionMatrixSamplerNonrev;
import stallone.mc.sampling.TransitionMatrixSamplerRev;
import stallone.mc.sampling.TransitionMatrixSamplerRevDeltaG;
import stallone.mc.sampling.TransitionMatrixSamplerRevFixPi;
import stallone.mc.tpt.Committor;
import stallone.mc.tpt.TPTFlux;

public class MarkovModelFactory {
    public IDoubleArray createPosteriorCountsNeighbor(IDoubleArray observedCounts, double prior) {
        IDoubleArray Cprior = observedCounts.create(observedCounts.rows(), observedCounts.columns());
        IDoubleIterator it = observedCounts.nonzeroIterator();
        while (it.hasNext()) {
            int col;
            int row = it.row();
            if (observedCounts.get(row, col = it.column()) + observedCounts.get(col, row) > 0.0) {
                Cprior.set(row, col, prior);
                Cprior.set(col, row, prior);
            }
            it.advance();
        }
        return new PosteriorCountMatrix(Cprior, observedCounts);
    }

    public IDoubleArray metropolisMC(IGriddedFunction f, double kT) {
        DiscretePotentialMetropolisMarkovChain mc = new DiscretePotentialMetropolisMarkovChain(f, kT);
        return mc.getTransitionMatrix();
    }

    public ICountMatrixEstimator createCountMatrixEstimatorSliding(Iterable<IIntArray> trajs, int lag) {
        CountMatrixEstimatorSliding cme = new CountMatrixEstimatorSliding(trajs);
        cme.setLag(lag);
        return cme;
    }

    public ICountMatrixEstimator createCountMatrixEstimatorSliding(IIntArray traj, int lag) {
        CountMatrixEstimatorSliding cme = new CountMatrixEstimatorSliding(traj);
        cme.setLag(lag);
        return cme;
    }

    public ICountMatrixEstimator createCountMatrixEstimatorStepping(Iterable<IIntArray> trajs, int lag) {
        CountMatrixEstimatorStepping cme = new CountMatrixEstimatorStepping(trajs);
        cme.setLag(lag);
        return cme;
    }

    public ICountMatrixEstimator createCountMatrixEstimatorStepping(IIntArray traj, int lag) {
        CountMatrixEstimatorStepping cme = new CountMatrixEstimatorStepping(traj);
        cme.setLag(lag);
        return cme;
    }

    public ITransitionMatrixEstimator createTransitionMatrixEstimatorNonrev() {
        return new TransitionMatrixEstimatorNonRev();
    }

    public ITransitionMatrixEstimator createTransitionMatrixEstimatorRev() {
        return new TransitionMatrixEstimatorRev();
    }

    public ITransitionMatrixEstimator createTransitionMatrixEstimatorRev(IDoubleArray pifix) {
        return new TransitionMatrixEstimatorRevFixPi(pifix);
    }

    public ITransitionMatrixSampler createTransitionMatrixSamplerNonrev(IDoubleArray counts) {
        TransitionMatrixSamplerNonrev sampler = new TransitionMatrixSamplerNonrev(counts);
        return sampler;
    }

    public ITransitionMatrixSampler createTransitionMatrixSamplerRev(IDoubleArray counts) {
        TransitionMatrixSamplerRev sampler = new TransitionMatrixSamplerRev(counts);
        return sampler;
    }

    public ITransitionMatrixSampler createTransitionMatrixSamplerRev(IDoubleArray counts, IDoubleArray piFix) {
        TransitionMatrixSamplerRevFixPi sampler = new TransitionMatrixSamplerRevFixPi(counts, piFix);
        return sampler;
    }

    public ITransitionMatrixSampler createTransitionMatrixSamplerRev(IDoubleArray counts, IDeltaGDistribution deltaG) {
        TransitionMatrixSamplerRevDeltaG sampler = new TransitionMatrixSamplerRevDeltaG(counts, deltaG);
        return sampler;
    }

    public ITransitionMatrixSampler createTransitionMatrixSamplerRev(IDoubleArray counts, IDeltaGDistribution deltaG, IDoubleArray Tinit) {
        TransitionMatrixSamplerRevDeltaG sampler = new TransitionMatrixSamplerRevDeltaG(counts, deltaG, Tinit);
        return sampler;
    }

    public IDeltaGDistribution createDeltaGGaussian(double mu, double sigma, int a, int b) {
        DeltaGGaussian deltaG = new DeltaGGaussian(mu, sigma, a, b);
        return deltaG;
    }

    public PCCA createPCCA(IDoubleArray M, int nstates) {
        PCCA pcca = new PCCA();
        IDoubleArray evec = M;
        if (MarkovModel.util.isTransitionMatrix(M)) {
            IEigenvalueDecomposition evd = Algebra.util.evd(M, nstates);
            evec = evd.getRightEigenvectorMatrix();
            evec = evec.viewBlock(0, 0, M.rows(), nstates);
        } else if (evec.columns() < nstates) {
            throw new IllegalArgumentException("Attempting to create PCCA decomposition into " + nstates + " states." + "but only " + evec.columns() + " eigenvectors were provided");
        }
        pcca.setEigenvectors(evec);
        pcca.perform();
        return pcca;
    }

    public ICommittor createCommittor(IDoubleArray T, IIntArray A, IIntArray B) {
        return this.createCommittor(T, MarkovModel.util.stationaryDistribution(T), A, B);
    }

    public ICommittor createCommittor(IDoubleArray T, IDoubleArray pi, IIntArray A, IIntArray B) {
        Committor comm = new Committor(T, A, B);
        comm.setStationaryDistribution(pi);
        return comm;
    }

    public ITPTFlux createTPT(IDoubleArray T, IIntArray A, IIntArray B) {
        return this.createTPT(T, MarkovModel.util.stationaryDistribution(T), A, B);
    }

    public ITPTFlux createTPT(IDoubleArray T, IDoubleArray initialDistribution, IIntArray A, IIntArray B) {
        TPTFlux tpt = new TPTFlux(T, A, B);
        tpt.setStationaryDistribution(initialDistribution);
        tpt.calculate();
        return tpt;
    }

    public IDynamicalExpectations createDynamicalExpectations(IDoubleArray T) {
        DynamicalExpectations dexp = new DynamicalExpectations(T);
        return dexp;
    }

    public IDynamicalExpectations createDynamicalExpectations(IDoubleArray T, IDoubleArray pi) {
        DynamicalExpectations dexp = new DynamicalExpectations(T);
        dexp.setStationaryDistribution(pi);
        return dexp;
    }

    public IDynamicalExpectationsSpectral createDynamicalFingerprint(IDoubleArray T) {
        return this.createDynamicalFingerprint(T);
    }

    public IDynamicalExpectationsSpectral createDynamicalFingerprint(IDoubleArray T, IDoubleArray pi) {
        DynamicalExpectationsSpectral dexp = new DynamicalExpectationsSpectral(T);
        dexp.setStationaryDistribution(pi);
        return dexp;
    }

    public IMarkovChain markovChain(IDoubleArray T) {
        return new MarkovChain(T);
    }

    public IMarkovChain markovChain(IDoubleArray startingDistribution, IDoubleArray T) {
        return new MarkovChain(startingDistribution, T);
    }
}

