/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import stallone.api.datasequence.IDataSequence;
import stallone.api.discretization.IDiscretization;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;

public class CoreDiscretization
implements IDiscretization {
    private IDataSequence centers;
    private double radius;
    private IMetric metric;

    public CoreDiscretization(IDataSequence _centers, double _radius, IMetric<IDoubleArray> _metric) {
        int i = 0;
        while (i < _centers.size() - 1) {
            int j = i + 1;
            while (j < _centers.size()) {
                double d = _metric.distance(_centers.get(i), _centers.get(j));
                if (d < 2.0 * _radius) {
                    throw new IllegalArgumentException("Illegal Core Discretization. Cores Overlap");
                }
                ++j;
            }
            ++i;
        }
        this.centers = _centers;
        this.radius = _radius;
        this.metric = _metric;
    }

    @Override
    public int assign(IDoubleArray p) {
        int i = 0;
        while (i < this.centers.size()) {
            if (this.metric.distance(this.centers.get(i), p) < this.radius) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public IDoubleArray assignFuzzy(IDoubleArray p) {
        IDoubleArray res = Doubles.create.array(this.centers.size());
        int s = this.assign(p);
        if (s != -1) {
            res.set(s, 1.0);
        }
        return res;
    }

    @Override
    public IDoubleArray getRepresentative(IDoubleArray p) {
        return this.centers.get(this.assign(p));
    }
}

