/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import java.util.Iterator;
import stallone.api.API;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.cluster.AbstractRegularClustering;

public class RandomClustering
extends AbstractRegularClustering {
    protected int nClusters;
    protected IIntArray centerIndexes;
    protected IIntArray data2cluster;

    public RandomClustering(int _nClusters) {
        this.nClusters = _nClusters;
    }

    private boolean isNew(IDataSequence acceptedCenters, IDoubleArray newCenter) {
        int i = 0;
        while (i < acceptedCenters.size()) {
            if (this.metric.distance(acceptedCenters.get(i), newCenter) == 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IDataList select(IIntArray indexes) {
        IDataList res = API.dataNew.list();
        Iterator dataIterator = this.data.iterator();
        int k = 0;
        int i = 0;
        while (i < this.datasize) {
            if (!dataIterator.hasNext()) {
                throw new RuntimeException("Data set is shorter than specified");
            }
            IDoubleArray x = (IDoubleArray)dataIterator.next();
            if (i == indexes.get(k)) {
                res.add(x);
                ++k;
            }
            if (k >= indexes.size()) break;
            ++i;
        }
        return res;
    }

    @Override
    public void perform() {
        int nfound = 0;
        int nsought = this.nClusters;
        IIntList acceptedCenterIndexes = API.intsNew.list(0);
        IDataList acceptedCenters = API.dataNew.list();
        int nAttempts = 0;
        while (nfound < this.nClusters && nAttempts <= 10) {
            IIntArray I = API.intsNew.arrayRandomIndexes(this.datasize, nsought);
            API.ints.sort(I);
            IDataList datapoints = this.select(I);
            int i = 0;
            while (i < I.size()) {
                if (this.isNew(acceptedCenters, datapoints.get(i))) {
                    acceptedCenterIndexes.append(I.get(i));
                    acceptedCenters.add(datapoints.get(i));
                }
                ++i;
            }
            nfound = acceptedCenters.size();
            ++nAttempts;
            nsought = this.nClusters - nfound;
        }
        this.centerIndexes = acceptedCenterIndexes;
        this.clusterCenters = acceptedCenters;
        this.voronoiPartitioning = API.discNew.voronoiDiscretization(this.clusterCenters, this.metric);
        this.data2cluster = API.intsNew.array(this.datasize);
        int k = 0;
        for (IDoubleArray y : this.data) {
            this.data2cluster.set(k++, this.voronoiPartitioning.assign(y));
        }
        this.resultsAvailable = true;
    }

    @Override
    public IIntArray getClusterIndexes() {
        return this.data2cluster;
    }
}

