/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence;

import java.util.List;
import stallone.api.datasequence.IDataSequence;
import stallone.datasequence.DataSequenceConcatenated;

public class DataSequenceConcatenatedInterleaved
extends DataSequenceConcatenated {
    private int step;

    public DataSequenceConcatenatedInterleaved(List<IDataSequence> _seqs, int _step) {
        this.seqs = _seqs;
        this.step = _step;
        int i = 0;
        while (i < _seqs.size()) {
            this.totalsize += _seqs.get(i).size() / this.step;
            if (this.dimension == -1) {
                this.dimension = _seqs.get(i).dimension();
            } else if (this.dimension != _seqs.get(i).dimension()) {
                throw new IllegalArgumentException("Data Sequence List has inconsistent dimensionality");
            }
            ++i;
        }
        this.microindex2trajindex = new int[this.totalsize];
        this.microindex2localindex = new int[this.totalsize];
        int k = 0;
        int l = 0;
        int i2 = 0;
        while (i2 < _seqs.size()) {
            int j = 0;
            while (j < _seqs.get(i2).size()) {
                if (k % this.step == 0) {
                    this.microindex2trajindex[l] = i2;
                    this.microindex2localindex[l] = j;
                    ++l;
                }
                ++k;
                ++j;
            }
            ++i2;
        }
    }
}

