/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence;

import java.util.Iterator;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.datasequence.DataSequenceIterator;
import stallone.datasequence.DataSequencePairIterator;

public class DataSequenceSubset
implements IDataSequence {
    private IDataSequence fullSequence;
    private IIntArray selection;

    public DataSequenceSubset(IDataSequence _fullSequence, IIntArray _selection) {
        this.fullSequence = _fullSequence;
        this.selection = _selection;
    }

    @Override
    public int size() {
        return this.selection.size();
    }

    @Override
    public int dimension() {
        return this.fullSequence.dimension();
    }

    @Override
    public double getTime(int i) {
        int sel = this.selection.get(i);
        return this.fullSequence.getTime(sel);
    }

    @Override
    public IDoubleArray get(int i) {
        int sel = this.selection.get(i);
        return this.fullSequence.get(sel);
    }

    @Override
    public IDoubleArray getView(int i) {
        int sel = this.selection.get(i);
        return this.fullSequence.getView(sel);
    }

    @Override
    public Iterator<IDoubleArray> iterator() {
        return new DataSequenceIterator(this);
    }

    @Override
    public Iterator<IDoubleArray[]> pairIterator(int spacing) {
        return new DataSequencePairIterator(this, spacing);
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        class PairIterable
        implements Iterable<IDoubleArray[]> {
            private IDataSequence seq;
            private int spacing = 1;

            public PairIterable(IDataSequence _seq, int _spacing) {
                this.seq = _seq;
                this.spacing = _spacing;
            }

            @Override
            public Iterator<IDoubleArray[]> iterator() {
                return new DataSequencePairIterator(this.seq, this.spacing);
            }
        }
        return new PairIterable(this, spacing);
    }
}

