/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.io.IReleasableFile;
import stallone.doubles.fastutils.LongArrayList;
import stallone.io.CachedRandomAccessFile;

public class XtcFile
implements IReleasableFile {
    protected String filename;
    protected CachedRandomAccessFile randomAccessFile;
    protected final int[] supportedMagicNrs = new int[]{1995};
    protected static final int[] xtc_magicints;
    protected int numOfFrames;
    protected long fileSize;
    protected long[] framePos;
    protected BitSet frameBroken;
    protected int nrOfCurrentFrameHeader;
    protected int nrOfCurrentFrameCoordinates;
    protected int frameSize;
    protected final int frameHeaderSize = 52;
    protected int coordinatesHeaderSize;
    protected int coordinatesHeaderAndCoordinatesSize;
    protected int magicNrFileVersion;
    protected int nrAtoms;
    protected int step;
    protected float t;
    protected float[] box;
    protected int nrAtomsCoordinatesHeader;
    protected float precision;
    protected int[] minInt;
    protected int[] maxInt;
    protected int amountBitsForCompressedCoordinates;
    protected int compressedCoordinatesLengthInByte;
    protected int[] coordinatesCompressed;
    protected IDoubleArray coordinatesUncompressed;
    protected int[] bytes = new int[32];
    protected ByteBuffer bb = null;
    protected boolean initialized = false;

    static {
        int[] nArray = new int[73];
        nArray[9] = 8;
        nArray[10] = 10;
        nArray[11] = 12;
        nArray[12] = 16;
        nArray[13] = 20;
        nArray[14] = 25;
        nArray[15] = 32;
        nArray[16] = 40;
        nArray[17] = 50;
        nArray[18] = 64;
        nArray[19] = 80;
        nArray[20] = 101;
        nArray[21] = 128;
        nArray[22] = 161;
        nArray[23] = 203;
        nArray[24] = 256;
        nArray[25] = 322;
        nArray[26] = 406;
        nArray[27] = 512;
        nArray[28] = 645;
        nArray[29] = 812;
        nArray[30] = 1024;
        nArray[31] = 1290;
        nArray[32] = 1625;
        nArray[33] = 2048;
        nArray[34] = 2580;
        nArray[35] = 3250;
        nArray[36] = 4096;
        nArray[37] = 5060;
        nArray[38] = 6501;
        nArray[39] = 8192;
        nArray[40] = 10321;
        nArray[41] = 13003;
        nArray[42] = 16384;
        nArray[43] = 20642;
        nArray[44] = 26007;
        nArray[45] = 32768;
        nArray[46] = 41285;
        nArray[47] = 52015;
        nArray[48] = 65536;
        nArray[49] = 82570;
        nArray[50] = 104031;
        nArray[51] = 131072;
        nArray[52] = 165140;
        nArray[53] = 208063;
        nArray[54] = 262144;
        nArray[55] = 330280;
        nArray[56] = 416127;
        nArray[57] = 524287;
        nArray[58] = 660561;
        nArray[59] = 832255;
        nArray[60] = 0x100000;
        nArray[61] = 1321122;
        nArray[62] = 1664510;
        nArray[63] = 0x200000;
        nArray[64] = 2642245;
        nArray[65] = 3329021;
        nArray[66] = 0x400000;
        nArray[67] = 5284491;
        nArray[68] = 6658042;
        nArray[69] = 0x7FFFFF;
        nArray[70] = 10568983;
        nArray[71] = 13316085;
        nArray[72] = 0x1000000;
        xtc_magicints = nArray;
    }

    public XtcFile() {
    }

    public XtcFile(String _filename) throws FileNotFoundException, IOException {
        this.filename = _filename;
        this.init();
    }

    public void setSource(String _filename) {
        this.filename = _filename;
    }

    public void scan() throws IOException {
        this.init();
    }

    private void init() throws FileNotFoundException, IOException {
        if (this.initialized) {
            return;
        }
        this.randomAccessFile = new CachedRandomAccessFile(this.filename);
        this.fileSize = this.randomAccessFile.length();
        this.magicNrFileVersion = this.randomAccessFile.readInt();
        Arrays.sort(this.supportedMagicNrs);
        if (Arrays.binarySearch(this.supportedMagicNrs, this.magicNrFileVersion) == -1) {
            System.out.println("Warning: Wrong magic number, this Gromacs version is not supported!");
        }
        this.nrAtoms = this.randomAccessFile.readInt();
        this.step = this.randomAccessFile.readInt();
        this.t = this.randomAccessFile.readFloat();
        this.box = new float[]{this.randomAccessFile.readFloat(), this.randomAccessFile.readFloat(), this.randomAccessFile.readFloat(), this.randomAccessFile.readFloat(), this.randomAccessFile.readFloat(), this.randomAccessFile.readFloat(), this.randomAccessFile.readFloat(), this.randomAccessFile.readFloat(), this.randomAccessFile.readFloat()};
        this.randomAccessFile.seek(0L);
        LongArrayList tempFramePositions = new LongArrayList(50000);
        int framesDetected = 0;
        long pos = 0L;
        do {
            pos = this.randomAccessFile.getFilePointer();
            tempFramePositions.add(pos);
            ++framesDetected;
            int magicRead = this.randomAccessFile.readInt();
            if (magicRead == this.magicNrFileVersion) {
                int noOfAtomsRead = this.randomAccessFile.readInt();
                this.randomAccessFile.skipBytes(44);
                int noOfAtomsRead2 = this.randomAccessFile.readInt();
                if (noOfAtomsRead == noOfAtomsRead2) {
                    if (noOfAtomsRead > 9) {
                        this.randomAccessFile.skipBytes(32);
                        int sizeOfCoordinates = this.randomAccessFile.readInt();
                        int mod4 = sizeOfCoordinates % 4;
                        if (mod4 > 0) {
                            sizeOfCoordinates += 4 - mod4;
                        }
                        this.randomAccessFile.skipBytes(sizeOfCoordinates);
                        continue;
                    }
                    this.randomAccessFile.skipBytes(noOfAtomsRead * 3 * 4);
                    continue;
                }
                throw new RuntimeException("Problem with atom sizes");
            }
            throw new RuntimeException("No magic bytes found. Error in trajectory.");
        } while (this.randomAccessFile.getFilePointer() < this.randomAccessFile.length());
        this.numOfFrames = framesDetected;
        int numberOfFrames = tempFramePositions.size();
        this.framePos = new long[numberOfFrames];
        this.frameBroken = new BitSet(numberOfFrames);
        long tmpPosition_old = 0L;
        int i = 0;
        while (i < numberOfFrames) {
            long tmpPosition = tempFramePositions.getLong(i);
            if ((tmpPosition - tmpPosition_old) % 4L != 0L) {
                this.frameBroken.set(i);
                System.err.println("WARNING: Frame " + i + " (numbering goes from 0 to n-1) has a wrong size. It's not a multiple of 4 bytes. This indicates that the frame may be broken. The frame is marked as broken.");
            }
            tmpPosition_old = tmpPosition;
            this.framePos[i] = tmpPosition;
            ++i;
        }
        if ((this.fileSize - tmpPosition_old) % 4L != 0L) {
            int frameNr = numberOfFrames - 1;
            this.frameBroken.set(frameNr);
            System.err.println("WARNING: Last frame " + frameNr + " (numbering goes from 0 to n-1) which was read from the trajectory has a wrong size. It's not a multiple of 4 bytes. This indicates that this frame may be broken. The frame is marked as broken.");
        }
        tempFramePositions = null;
        this.coordinatesUncompressed = API.doublesNew.matrix(this.nrAtoms, 3);
        this.randomAccessFile.seek(0L);
        this.nrOfCurrentFrameHeader = -1;
        this.nrOfCurrentFrameCoordinates = -1;
        this.initialized = true;
    }

    public int nDOF() {
        return this.nrAtoms * 3;
    }

    public int nAtoms() {
        return this.nrAtoms;
    }

    public int nFrames() {
        if (this.framePos == null) {
            return 0;
        }
        return this.numOfFrames;
    }

    public boolean frameHasPosition(int frameIndex) throws IOException {
        if (!this.readFrame(frameIndex)) {
            return false;
        }
        return this.coordinatesHeaderAndCoordinatesSize > 0;
    }

    public int getFrameSize(int frameIndex) {
        if (this.numOfFrames == 0 || frameIndex >= this.numOfFrames) {
            return 0;
        }
        if (frameIndex < this.numOfFrames - 1) {
            return (int)(this.framePos[frameIndex + 1] - this.framePos[frameIndex]);
        }
        return (int)(this.fileSize - this.framePos[frameIndex]);
    }

    public int getFrameSize(int frameIndex, boolean show) {
        System.out.println("From: " + this.framePos[frameIndex]);
        System.out.println("To: " + this.framePos[frameIndex + 1]);
        return this.getFrameSize(frameIndex);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean readFrame(int frameIndex) throws IOException {
        block13: {
            if (frameIndex >= this.numOfFrames) {
                return false;
            }
            if (this.frameBroken.get(frameIndex)) {
                System.err.println("WARNING: You are trying to read from a broken frame " + frameIndex + " (numbering goes from 0 to n-1). This is not allowed! Please fix first the error in your trajectory.");
                return false;
            }
            if (this.nrOfCurrentFrameHeader != frameIndex) {
                this.nrOfCurrentFrameHeader = frameIndex;
                this.frameSize = this.getFrameSize(frameIndex);
                this.coordinatesHeaderAndCoordinatesSize = this.frameSize - 52;
                this.randomAccessFile.seek(this.framePos[frameIndex]);
                if (this.bb == null || this.bb.capacity() < this.frameSize) {
                    newSize = (int)Math.floor((double)this.frameSize * 1.5);
                    this.bb = ByteBuffer.wrap(new byte[newSize]);
                }
                this.bb.clear();
                this.randomAccessFile.readFully(this.bb.array(), this.frameSize);
                try {
                    this.magicNrFileVersion = this.bb.getInt();
                    this.nrAtoms = this.bb.getInt();
                    this.step = this.bb.getInt();
                    this.t = this.bb.getFloat();
                    this.box = new float[]{this.bb.getFloat(), this.bb.getFloat(), this.bb.getFloat(), this.bb.getFloat(), this.bb.getFloat(), this.bb.getFloat(), this.bb.getFloat(), this.bb.getFloat(), this.bb.getFloat()};
                    this.nrAtomsCoordinatesHeader = this.bb.getInt();
                    if (this.nrAtoms > 9) {
                        this.coordinatesHeaderSize = 40;
                        this.precision = this.bb.getFloat();
                        this.minInt = new int[]{this.bb.getInt(), this.bb.getInt(), this.bb.getInt()};
                        this.maxInt = new int[]{this.bb.getInt(), this.bb.getInt(), this.bb.getInt()};
                        this.amountBitsForCompressedCoordinates = this.bb.getInt();
                        this.compressedCoordinatesLengthInByte = this.bb.getInt();
                        compressedCoordinatesSizeInFourBytesMeasure = this.coordinatesHeaderAndCoordinatesSize / 4 - 10;
                        this.coordinatesCompressed = new int[compressedCoordinatesSizeInFourBytesMeasure + 3];
                        if (this.compressedCoordinatesLengthInByte + (4 - this.compressedCoordinatesLengthInByte % 4) % 4 != this.coordinatesHeaderAndCoordinatesSize - this.coordinatesHeaderSize) {
                            this.frameBroken.set(frameIndex);
                            System.err.println("WARNING: Coordinates section of frame " + frameIndex + " (numbering goes from 0 to n-1) has a wrong size. It's not a multiple of 4 bytes. This indicates that this frames may be broken. Frame marked as broken.");
                        }
                        ii = 3;
                        while (ii < compressedCoordinatesSizeInFourBytesMeasure + 3) {
                            this.coordinatesCompressed[ii] = this.bb.getInt();
                            ++ii;
                        }
                    } else {
                        this.coordinatesHeaderSize = 4;
                        this.precision = 0.0f;
                        this.minInt = new int[3];
                        this.maxInt = new int[3];
                        this.amountBitsForCompressedCoordinates = 0;
                        this.compressedCoordinatesLengthInByte = 0;
                        iiAtom = 0;
                        while (iiAtom < this.nrAtoms) {
                            this.coordinatesUncompressed.set(iiAtom, 0, this.bb.getFloat());
                            this.coordinatesUncompressed.set(iiAtom, 1, this.bb.getFloat());
                            this.coordinatesUncompressed.set(iiAtom, 2, this.bb.getFloat());
                            ++iiAtom;
                        }
                    }
                    break block13;
                }
                catch (BufferUnderflowException e) {
                    e.printStackTrace();
                    System.out.println("Frame current " + frameIndex + " from " + this.framePos[frameIndex] + " to " + this.framePos[frameIndex + 1]);
                    buf = this.bb.array();
                    i = 0;
                    ** while (i < buf.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (i % 16 == 0) {
                        System.out.println("");
                    }
                    b = buf[i];
                    System.out.print(String.valueOf(XtcFile.byteToString(b)) + " ");
                    ++i;
                    continue;
                }
lbl68:
                // 1 sources

                System.out.println("");
                System.out.println("Frame current - 1 " + (frameIndex - 1) + " from " + this.framePos[frameIndex - 1] + " to " + this.framePos[frameIndex - 1 + 1]);
                System.out.println("Frame current + 1 " + (frameIndex + 1) + " from " + this.framePos[frameIndex + 1] + " to " + this.framePos[frameIndex + 1 + 1]);
                throw new RuntimeException("Unrecoverable trajectory error.");
            }
        }
        return true;
    }

    public static String byteToString(byte in) {
        byte ch = 0;
        String out = new String("");
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        ch = (byte)(in & 0xF0);
        ch = (byte)(ch >>> 4);
        ch = (byte)(ch & 0xF);
        out = String.valueOf(out) + pseudo[ch];
        ch = (byte)(in & 0xF);
        out = String.valueOf(out) + pseudo[ch];
        return out;
    }

    protected boolean uncompressFrameCoordinates(int frameIndex, IDoubleArray out) throws IOException {
        if (frameIndex >= this.numOfFrames) {
            return false;
        }
        if (this.frameBroken.get(frameIndex)) {
            System.err.println("WARNING: You are trying to read from a broken frame " + frameIndex + " (numbering goes from 0 to n-1). This is not allowed! Please fix first the error in your trajectory.");
            return false;
        }
        if (this.nrOfCurrentFrameCoordinates != frameIndex) {
            if (this.nrOfCurrentFrameHeader != frameIndex) {
                this.readFrame(frameIndex);
            }
            this.nrOfCurrentFrameCoordinates = frameIndex;
            if (this.nrAtoms > 9) {
                this.coordinatesUncompressed = this.xdr3dfcoord(this.coordinatesCompressed, this.nrAtoms, this.precision, out);
            }
        }
        return true;
    }

    public IDoubleArray getPositionsAt(int frameIndex, IDoubleArray out) throws IOException {
        if (!this.readFrame(frameIndex)) {
            return null;
        }
        if (!this.uncompressFrameCoordinates(frameIndex, out)) {
            return null;
        }
        return this.coordinatesUncompressed;
    }

    public float getPrecisionAt(int frameIndex) throws IOException {
        if (!this.readFrame(frameIndex)) {
            return 0.0f;
        }
        return this.precision;
    }

    public float[] getForcesAt(int frameIndex) throws IOException {
        return null;
    }

    public float[] getBoxAt(int frameIndex) throws IOException {
        if (!this.readFrame(frameIndex)) {
            return null;
        }
        return this.box;
    }

    public int getNumberOfAtomsAt(int frameIndex) throws IOException {
        if (!this.readFrame(frameIndex)) {
            return 0;
        }
        return this.nrAtoms;
    }

    public int getStepAt(int frameIndex) throws IOException {
        if (!this.readFrame(frameIndex)) {
            return 0;
        }
        return this.step;
    }

    public float getTimeAt(int frameIndex) throws IOException {
        if (!this.readFrame(frameIndex)) {
            return 0.0f;
        }
        return this.t;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public void open() throws IOException {
        this.randomAccessFile = new CachedRandomAccessFile(this.filename);
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    private static int sizeofint(int maxSize) {
        int num = 1;
        int num_of_bits = 0;
        while (maxSize >= num && num_of_bits < 32) {
            ++num_of_bits;
            num <<= 1;
        }
        return num_of_bits;
    }

    private static int sizeofints(int[] sizes) {
        int[] bytes = new int[32];
        int num_of_bytes = 1;
        bytes[0] = 1;
        int num_of_bits = 0;
        int i = 0;
        while (i < 3) {
            int tmp = 0;
            int bytecnt = 0;
            while (bytecnt < num_of_bytes) {
                tmp = bytes[bytecnt] * sizes[i] + tmp;
                bytes[bytecnt] = tmp & 0xFF;
                tmp >>= 8;
                ++bytecnt;
            }
            while (tmp != 0) {
                bytes[bytecnt++] = tmp & 0xFF;
                tmp >>= 8;
            }
            num_of_bytes = bytecnt;
            ++i;
        }
        int num = 1;
        --num_of_bytes;
        while (bytes[num_of_bytes] >= num) {
            ++num_of_bits;
            num *= 2;
        }
        return num_of_bits + num_of_bytes * 8;
    }

    private int receivebits(int[] buf, int num_of_bits) {
        try {
            int cnt_tmp;
            int mask = (1 << num_of_bits) - 1;
            int bitMaskToConvertByteProperlyToIntInJava = 255;
            int cnt = buf[0];
            int lastbits = buf[1];
            int lastbyte = buf[2];
            int buf_readPosition = cnt / 4 + 3;
            int cnt_tmpStart = cnt_tmp = cnt % 4;
            byte[] cbuf = new byte[4];
            int num = 0;
            while (num_of_bits >= 8) {
                cbuf[0] = (byte)(buf[buf_readPosition] >> 24 & 0xFF);
                cbuf[1] = (byte)(buf[buf_readPosition] >> 16 & 0xFF);
                cbuf[2] = (byte)(buf[buf_readPosition] >> 8 & 0xFF);
                cbuf[3] = (byte)(buf[buf_readPosition] & 0xFF);
                lastbyte = lastbyte << 8 | cbuf[cnt_tmp++] & 0xFF;
                num |= lastbyte >> lastbits << num_of_bits - 8;
                num_of_bits -= 8;
            }
            if (num_of_bits > 0) {
                if (lastbits < num_of_bits) {
                    cbuf[0] = (byte)(buf[buf_readPosition] >> 24 & 0xFF);
                    cbuf[1] = (byte)(buf[buf_readPosition] >> 16 & 0xFF);
                    cbuf[2] = (byte)(buf[buf_readPosition] >> 8 & 0xFF);
                    cbuf[3] = (byte)(buf[buf_readPosition] & 0xFF);
                    lastbits += 8;
                    lastbyte = lastbyte << 8 | cbuf[cnt_tmp++] & 0xFF;
                }
                num |= lastbyte >> (lastbits -= num_of_bits) & (1 << num_of_bits) - 1;
            }
            buf[0] = cnt + cnt_tmp - cnt_tmpStart;
            buf[1] = lastbits;
            buf[2] = lastbyte;
            return num &= mask;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("ERROR: Incomplete frame " + this.nrOfCurrentFrameCoordinates + " (numbering goes from 0 to n-1). It's probably an error in the 'coordinates' section of this frame. For safty reasons the JVM is terminated!");
            System.err.println(e.getMessage());
            System.exit(-1);
            return 0;
        }
    }

    private int[] receiveints(int[] buf, int num_of_bits, int[] sizes) {
        int num_of_ints = 3;
        Arrays.fill(this.bytes, 0);
        int[] nums = new int[3];
        int num_of_bytes = 0;
        while (num_of_bits > 8) {
            this.bytes[num_of_bytes++] = this.receivebits(buf, 8);
            num_of_bits -= 8;
        }
        if (num_of_bits > 0) {
            this.bytes[num_of_bytes++] = this.receivebits(buf, num_of_bits);
        }
        int i = 2;
        while (i > 0) {
            int num = 0;
            int sizes_valueAtPostionI = sizes[i];
            int j = num_of_bytes - 1;
            while (j >= 0) {
                int p;
                num = num << 8 | this.bytes[j];
                this.bytes[j] = p = num / sizes_valueAtPostionI;
                num -= p * sizes_valueAtPostionI;
                --j;
            }
            nums[i] = num;
            --i;
        }
        nums[0] = this.bytes[0] | this.bytes[1] << 8 | this.bytes[2] << 16 | this.bytes[3] << 24;
        return nums;
    }

    private IDoubleArray xdr3dfcoord(int[] coordinatesCompressed, int nrAtoms, float precision, IDoubleArray out) {
        int bitSize;
        int[] sizeInt = new int[3];
        int[] sizeSmall = new int[3];
        int[] thiscoord = new int[3];
        int[] prevcoord = new int[3];
        int[] bitsizeInt = new int[3];
        int firstidx = 9;
        int smallidx = this.amountBitsForCompressedCoordinates;
        int smaller = xtc_magicints[Math.max(9, smallidx - 1)] / 2;
        int small = xtc_magicints[smallidx] / 2;
        sizeSmall[1] = sizeSmall[2] = xtc_magicints[smallidx];
        sizeSmall[0] = sizeSmall[2];
        float inv_precision = (float)(1.0 / (double)precision);
        int[] buf = coordinatesCompressed;
        buf[2] = 0;
        buf[1] = 0;
        buf[0] = 0;
        sizeInt[0] = this.maxInt[0] - this.minInt[0] + 1;
        sizeInt[1] = this.maxInt[1] - this.minInt[1] + 1;
        sizeInt[2] = this.maxInt[2] - this.minInt[2] + 1;
        if ((sizeInt[0] | sizeInt[1] | sizeInt[2]) > 0xFFFFFF) {
            bitsizeInt[0] = XtcFile.sizeofint(sizeInt[0]);
            bitsizeInt[1] = XtcFile.sizeofint(sizeInt[1]);
            bitsizeInt[2] = XtcFile.sizeofint(sizeInt[2]);
            bitSize = 0;
        } else {
            bitSize = XtcFile.sizeofints(sizeInt);
        }
        int run = 0;
        int i = 0;
        int iOutput = 0;
        while (i < nrAtoms) {
            if (bitSize == 0) {
                thiscoord[0] = this.receivebits(buf, bitsizeInt[0]);
                thiscoord[1] = this.receivebits(buf, bitsizeInt[1]);
                thiscoord[2] = this.receivebits(buf, bitsizeInt[2]);
            } else {
                thiscoord = this.receiveints(buf, bitSize, sizeInt);
            }
            ++i;
            thiscoord[0] = thiscoord[0] + this.minInt[0];
            thiscoord[1] = thiscoord[1] + this.minInt[1];
            thiscoord[2] = thiscoord[2] + this.minInt[2];
            prevcoord[0] = thiscoord[0];
            prevcoord[1] = thiscoord[1];
            prevcoord[2] = thiscoord[2];
            int flag = this.receivebits(buf, 1);
            int is_smaller = 0;
            if (flag == 1) {
                run = this.receivebits(buf, 5);
                is_smaller = run % 3;
                run -= is_smaller;
                --is_smaller;
            }
            if (run > 0) {
                int k = 0;
                while (k < run) {
                    thiscoord = this.receiveints(buf, smallidx, sizeSmall);
                    ++i;
                    thiscoord[0] = thiscoord[0] + (prevcoord[0] - small);
                    thiscoord[1] = thiscoord[1] + (prevcoord[1] - small);
                    thiscoord[2] = thiscoord[2] + (prevcoord[2] - small);
                    if (k == 0) {
                        int tmp = thiscoord[0];
                        thiscoord[0] = prevcoord[0];
                        prevcoord[0] = tmp;
                        tmp = thiscoord[1];
                        thiscoord[1] = prevcoord[1];
                        prevcoord[1] = tmp;
                        tmp = thiscoord[2];
                        thiscoord[2] = prevcoord[2];
                        prevcoord[2] = tmp;
                        out.set(iOutput, 0, (float)prevcoord[0] * inv_precision);
                        out.set(iOutput, 1, (float)prevcoord[1] * inv_precision);
                        out.set(iOutput, 2, (float)prevcoord[2] * inv_precision);
                        ++iOutput;
                    } else {
                        prevcoord[0] = thiscoord[0];
                        prevcoord[1] = thiscoord[1];
                        prevcoord[2] = thiscoord[2];
                    }
                    out.set(iOutput, 0, (float)thiscoord[0] * inv_precision);
                    out.set(iOutput, 1, (float)thiscoord[1] * inv_precision);
                    out.set(iOutput, 2, (float)thiscoord[2] * inv_precision);
                    ++iOutput;
                    k += 3;
                }
            } else {
                out.set(iOutput, 0, (float)thiscoord[0] * inv_precision);
                out.set(iOutput, 1, (float)thiscoord[1] * inv_precision);
                out.set(iOutput, 2, (float)thiscoord[2] * inv_precision);
                ++iOutput;
            }
            smallidx += is_smaller;
            if (is_smaller < 0) {
                small = smaller;
                smaller = smallidx > 9 ? xtc_magicints[smallidx - 1] / 2 : 0;
            } else if (is_smaller > 0) {
                smaller = small;
                small = xtc_magicints[smallidx] / 2;
            }
            sizeSmall[1] = sizeSmall[2] = xtc_magicints[smallidx];
            sizeSmall[0] = sizeSmall[2];
        }
        return out;
    }
}

