/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence.io;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import stallone.api.API;
import stallone.api.datasequence.DataSequence;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataReader;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.datasequence.io.DataReaderIterator;
import stallone.datasequence.io.DataReaderPairIterator;
import stallone.datasequence.io.XtcFile;
import stallone.ints.PrimitiveIntTools;

public class XtcReader
implements IDataReader {
    private XtcFile trajectory;
    private IDoubleArray preconstructedFrame;
    private int[] selection = null;

    public XtcReader(String trajFilename) throws IOException {
        this.trajectory = new XtcFile(trajFilename);
        this.preconstructedFrame = API.doublesNew.matrix(this.trajectory.nrAtoms, 3);
    }

    @Override
    public void setSource(String name) {
        this.trajectory.setSource(name);
    }

    @Override
    public void scan() throws IOException {
        this.trajectory.scan();
    }

    @Override
    public int dimension() {
        return this.trajectory.nDOF();
    }

    @Override
    public int size() {
        return this.trajectory.nFrames();
    }

    @Override
    public void select(int[] _selection) {
        this.selection = _selection;
    }

    @Override
    public int[] getSelection() {
        if (this.selection == null) {
            return PrimitiveIntTools.range(this.trajectory.nrAtoms);
        }
        return this.selection;
    }

    public IDoubleArray get(int frameIndex, IDoubleArray target) {
        try {
            if (this.selection == null) {
                return this.trajectory.getPositionsAt(frameIndex, target);
            }
            this.trajectory.getPositionsAt(frameIndex, this.preconstructedFrame);
            int i = 0;
            while (i < this.selection.length) {
                target.set(i, 0, this.preconstructedFrame.get(this.selection[i], 0));
                target.set(i, 1, this.preconstructedFrame.get(this.selection[i], 1));
                target.set(i, 2, this.preconstructedFrame.get(this.selection[i], 2));
                ++i;
            }
            return target;
        }
        catch (IOException ex) {
            Logger.getLogger(XtcReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("Unable to read frame " + frameIndex + ".");
        }
    }

    @Override
    public void close() throws IOException {
        this.trajectory.close();
    }

    @Override
    public void open() throws IOException {
        this.trajectory.open();
    }

    @Override
    public double getTime(int frameIndex) {
        try {
            return this.trajectory.getTimeAt(frameIndex);
        }
        catch (IOException e) {
            return frameIndex;
        }
    }

    @Override
    public IDoubleArray get(int frameIndex) {
        if (this.selection == null) {
            return this.get(frameIndex, API.doublesNew.array(this.trajectory.nrAtoms, 3));
        }
        return this.get(frameIndex, API.doublesNew.array(this.selection.length, 3));
    }

    @Override
    public IDoubleArray getView(int index) {
        return this.get(index);
    }

    @Override
    public Iterator<IDoubleArray> iterator() {
        return new DataReaderIterator(this);
    }

    @Override
    public Iterator<IDoubleArray[]> pairIterator(int spacing) {
        return new DataReaderPairIterator(this, spacing);
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        class PairIterable
        implements Iterable<IDoubleArray[]> {
            private IDataReader seq;
            private int spacing = 1;

            public PairIterable(IDataReader _seq, int _spacing) {
                this.seq = _seq;
                this.spacing = _spacing;
            }

            @Override
            public Iterator<IDoubleArray[]> iterator() {
                return new DataReaderPairIterator(this.seq, this.spacing);
            }
        }
        return new PairIterable(this, spacing);
    }

    @Override
    public IDataSequence load() {
        IDataList res = DataSequence.create.list();
        int i = 0;
        while (i < this.size()) {
            res.add(this.get(i));
            ++i;
        }
        return res;
    }

    public String getFileName() {
        return this.trajectory.getFileName();
    }

    @Override
    public long memorySize() {
        return this.size() * this.dimension() * 8;
    }
}

