/*
 * Decompiled with CFR 0.152.
 */
package stallone.discretization;

import java.util.Iterator;
import stallone.api.API;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.api.function.IFunction;
import stallone.api.function.IGrid;
import stallone.api.function.IGriddedFunction;
import stallone.api.ints.IIntArray;
import stallone.discretization.Grid;

public class GriddedFunctionOnDemand
implements IGriddedFunction {
    private IFunction F;
    private IGrid grid;

    public GriddedFunctionOnDemand(IFunction _F, IDoubleArray bounds, double boxsize) {
        this.F = _F;
        if (bounds.rows() != _F.getNumberOfVariables()) {
            throw new IllegalArgumentException("Number of variables in function is different from number of discretization bounds provided");
        }
        this.grid = new Grid(bounds, boxsize);
    }

    public GriddedFunctionOnDemand(IFunction _F, IDoubleArray griddef) {
        this.F = _F;
        this.grid = new Grid(griddef);
    }

    @Override
    public double f(int ... indexes) {
        if (indexes.length != this.F.getNumberOfVariables()) {
            throw new IllegalArgumentException("Wrong number of variables.");
        }
        IDoubleArray x = this.grid.getPoint(indexes);
        return this.F.f(x);
    }

    @Override
    public double f(IIntArray indexes) {
        return this.f(indexes.getArray());
    }

    @Override
    public int getNumberOfGridPoints() {
        return this.grid.getNumberOfGridPoints();
    }

    @Override
    public int getNumberOfGridPoints(int dimension) {
        return this.grid.getNumberOfGridPoints(dimension);
    }

    @Override
    public IIntArray getNeighborIndexes(int index) {
        return this.grid.getNeighborIndexes(index);
    }

    @Override
    public IDataSequence getNeighbors(int index) {
        return this.grid.getNeighbors(index);
    }

    @Override
    public int assign(IDoubleArray x) {
        return this.grid.assign(x);
    }

    @Override
    public IDoubleArray assignFuzzy(IDoubleArray x) {
        return this.grid.assignFuzzy(x);
    }

    @Override
    public IDoubleArray getRepresentative(IDoubleArray x) {
        return this.grid.getRepresentative(x);
    }

    @Override
    public int getIndex(IIntArray indexes) {
        return this.grid.getIndex(indexes);
    }

    @Override
    public IDoubleArray getPoint(IIntArray indexes) {
        return this.grid.getPoint(indexes);
    }

    @Override
    public int getIndex(int ... indexes) {
        return this.getIndex(indexes);
    }

    @Override
    public IDoubleArray getPoint(int ... indexes) {
        return this.getPoint(indexes);
    }

    @Override
    public int size() {
        return this.grid.size();
    }

    @Override
    public int dimension() {
        return this.grid.dimension();
    }

    @Override
    public IDoubleArray get(int i) {
        return this.grid.get(i);
    }

    @Override
    public Iterator<IDoubleArray> iterator() {
        return this.grid.iterator();
    }

    @Override
    public double f(IDoubleArray x) {
        IDoubleArray y = this.grid.getRepresentative(x);
        return this.F.f(y);
    }

    @Override
    public double f(double ... x) {
        return this.f(API.doublesNew.array(x));
    }

    @Override
    public int getNumberOfVariables() {
        return this.F.getNumberOfVariables();
    }

    @Override
    public IIntArray nearestMultiIndex(IDoubleArray x) {
        return this.grid.nearestMultiIndex(x);
    }

    @Override
    public IIntArray getNeighborMultiIndexes(int ... indexes) {
        return this.grid.getNeighborMultiIndexes(indexes);
    }

    @Override
    public IDoubleArray getView(int i) {
        return this.get(i);
    }

    @Override
    public double getTime(int i) {
        return i;
    }

    @Override
    public Iterator<IDoubleArray[]> pairIterator(int spacing) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

