/*
 * Decompiled with CFR 0.152.
 */
package stallone.discretization;

import stallone.api.datasequence.IDataSequence;
import stallone.api.discretization.IDiscretization;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;

public class VoronoiDiscretization
implements IDiscretization {
    private IDataSequence clusterCenters;
    private IMetric<IDoubleArray> metric;

    public VoronoiDiscretization(IDataSequence _clusterCenters, IMetric<IDoubleArray> _metric) {
        this.clusterCenters = _clusterCenters;
        this.metric = _metric;
    }

    @Override
    public int assign(IDoubleArray p) {
        double minimalDistance = Double.MAX_VALUE;
        int indexOfClosestCluster = -1;
        int n = this.clusterCenters.size();
        int i = 0;
        while (i < n) {
            IDoubleArray v_i = this.clusterCenters.get(i);
            double currentDistance = this.metric.distance(p, v_i);
            if (currentDistance < minimalDistance) {
                minimalDistance = currentDistance;
                indexOfClosestCluster = i;
            }
            ++i;
        }
        if (indexOfClosestCluster != -1) {
            return indexOfClosestCluster;
        }
        throw new RuntimeException("Can not assign cluster.");
    }

    @Override
    public IDoubleArray getRepresentative(IDoubleArray p) {
        return this.clusterCenters.get(this.assign(p));
    }

    @Override
    public IDoubleArray assignFuzzy(IDoubleArray p) {
        IDoubleArray membership = Doubles.create.array(this.clusterCenters.size());
        int j = 0;
        while (j < membership.size()) {
            membership.set(j, 0.0);
            ++j;
        }
        int clusterIndex = this.assign(p);
        membership.set(clusterIndex, 1.0);
        return membership;
    }

    public void setClusterCenters(IDataSequence clusterCenters) {
        this.clusterCenters = clusterCenters;
    }

    public void setMetric(IMetric<IDoubleArray> metric) {
        this.metric = metric;
    }
}

