/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDoubleArray;
import stallone.doubles.IArrayIndexMap;

class ArrayBlockIndexMap
implements IArrayIndexMap {
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int nrows;
    private int ncols;
    private int size;

    public ArrayBlockIndexMap(IDoubleArray data, int _top, int _left, int _bottom, int _right) {
        this.left = _left;
        this.top = _top;
        this.right = _right;
        this.bottom = _bottom;
        this.nrows = _bottom - _top;
        this.ncols = _right - _left;
        this.size = this.nrows * this.ncols;
    }

    public ArrayBlockIndexMap(IDoubleArray data, int _from, int _to) {
        if (data.order() > 1) {
            throw new IllegalArgumentException("Cannot use order-1 array view constructor for a table");
        }
        if (data.columns() == 1) {
            this.top = _from;
            this.bottom = _to;
            this.left = 0;
            this.right = 1;
            this.nrows = _to - _from;
            this.ncols = 1;
            this.size = this.nrows;
        }
        if (data.rows() == 1) {
            this.left = _from;
            this.right = _to;
            this.top = 0;
            this.bottom = 1;
            this.nrows = 1;
            this.size = this.ncols = _to - _from;
        }
    }

    @Override
    public int getRow(int row) {
        return row + this.top;
    }

    @Override
    public int getColumn(int column) {
        return column + this.left;
    }

    @Override
    public int rows() {
        return this.nrows;
    }

    @Override
    public int columns() {
        return this.ncols;
    }

    @Override
    public int size() {
        return this.size;
    }
}

