/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import java.util.Arrays;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.AbstractDoubleArray;

public class DiagonalMatrix
extends AbstractDoubleArray {
    private double[] diagonal;

    public DiagonalMatrix(double[] diagonal) {
        this.diagonal = diagonal;
    }

    public DiagonalMatrix(IDoubleArray matrixOrVector) {
        switch (matrixOrVector.order()) {
            case 1: {
                this.diagonal = matrixOrVector.getArray();
                break;
            }
            case 2: {
                if (matrixOrVector.rows() != matrixOrVector.columns()) {
                    throw new IllegalArgumentException("no symetric matrix given");
                }
                this.diagonal = new double[matrixOrVector.rows()];
                int i = 0;
                while (i < matrixOrVector.rows()) {
                    this.diagonal[i] = matrixOrVector.get(i, i);
                    ++i;
                }
            }
            default: {
                throw new IllegalArgumentException("tensors not impled.");
            }
        }
    }

    @Override
    public int rows() {
        return this.diagonal.length;
    }

    @Override
    public int columns() {
        return this.diagonal.length;
    }

    @Override
    public double get(int i, int j) {
        assert (i < this.diagonal.length && j < this.diagonal.length);
        if (i == j) {
            return this.diagonal[i];
        }
        return 0.0;
    }

    @Override
    public void set(int i, int j, double x) {
        assert (i < this.diagonal.length && j < this.diagonal.length);
        if (i != j) {
            throw new IllegalArgumentException("trying to set off diagonal element of sparse matrix");
        }
        this.diagonal[i] = x;
    }

    @Override
    public IDoubleArray copy() {
        double[] diag = Arrays.copyOf(this.diagonal, this.diagonal.length);
        return new DiagonalMatrix(diag);
    }

    @Override
    public IDoubleArray create(int size) {
        return new DiagonalMatrix(new double[size]);
    }

    @Override
    public IDoubleArray create(int rows, int columns) {
        return new DiagonalMatrix(new double[rows]);
    }

    @Override
    public boolean isSparse() {
        return true;
    }
}

