/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleElement;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.DoubleTableElement;

public class DoubleTableIterator
implements IDoubleIterator {
    protected DoubleTableElement o;
    protected IDoubleArray X;
    protected int i = 0;
    protected int j = 0;
    protected int rows;
    protected int cols;

    public DoubleTableIterator(IDoubleArray _X) {
        this.X = _X;
        this.rows = this.X.rows();
        this.cols = this.X.columns();
        this.o = new DoubleTableElement(this.X, 0, 0);
    }

    @Override
    public void reset() {
        this.i = 0;
        this.j = 0;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.rows && this.j < this.cols;
    }

    @Override
    public int row() {
        return this.i;
    }

    @Override
    public int column() {
        return this.j;
    }

    @Override
    public void advance() {
        if (this.j == this.cols - 1) {
            ++this.i;
            this.j = 0;
        } else {
            ++this.j;
        }
    }

    @Override
    public double get() {
        return this.X.get(this.i, this.j);
    }

    @Override
    public void set(double newValue) {
        this.X.set(this.i, this.j, newValue);
    }

    @Override
    public IDoubleElement next() {
        this.o.setIndex(this.i, this.j);
        this.advance();
        return this.o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported.");
    }

    @Override
    public int getIndex() {
        return this.i * this.cols + this.j;
    }
}

