/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.API;
import stallone.api.doubles.IDoubleElement;
import stallone.api.doubles.IDoubleIterator;
import stallone.api.ints.IIntList;
import stallone.doubles.DoubleTableElement;
import stallone.doubles.SparseRealMatrix;

class SparseRealMatrixNonzeroIterator
implements IDoubleIterator {
    private SparseRealMatrix M;
    int nrows;
    int ncols;
    private DoubleTableElement de;
    private IIntList nonzeroRows;
    int irow = 0;
    int icol = 0;
    int row = 0;
    int col = 0;

    public SparseRealMatrixNonzeroIterator(SparseRealMatrix _M) {
        this.M = _M;
        this.nrows = _M.rows();
        this.ncols = _M.columns();
        this.de = new DoubleTableElement(_M, 0, 0);
        this.nonzeroRows = API.intsNew.list(0);
        int i = 0;
        while (i < _M.rows()) {
            if (_M.rowVectors[i].getNumberOfNonzero() > 0) {
                this.nonzeroRows.append(i);
            }
            ++i;
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.irow = 0;
        this.icol = 0;
        this.row = this.nonzeroRows.get(this.irow);
        this.col = this.M.rowVectors[this.row].getIndexMap().nonZeroIndices[this.icol];
        this.de = new DoubleTableElement(this.M, this.row, this.col);
    }

    @Override
    public boolean hasNext() {
        if (this.irow >= this.nonzeroRows.size()) {
            return false;
        }
        return this.icol < this.M.rowVectors[this.row].getIndexMap().usedNonZero;
    }

    @Override
    public void advance() {
        if (this.icol + 1 < this.M.rowVectors[this.row].getIndexMap().usedNonZero) {
            ++this.icol;
        } else {
            ++this.irow;
            this.icol = 0;
        }
        if (this.irow >= this.nonzeroRows.size()) {
            return;
        }
        this.row = this.nonzeroRows.get(this.irow);
        this.col = this.M.rowVectors[this.row].getIndexMap().nonZeroIndices[this.icol];
    }

    @Override
    public int getIndex() {
        return this.row * this.ncols + this.col;
    }

    @Override
    public double get() {
        return this.M.get(this.row, this.col);
    }

    @Override
    public void set(double newValue) {
        this.M.set(this.row, this.col, newValue);
    }

    @Override
    public IDoubleElement next() {
        this.de.setIndex(this.row, this.col);
        this.advance();
        return this.de;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported.");
    }

    @Override
    public int row() {
        return this.row;
    }

    @Override
    public int column() {
        return this.col;
    }
}

