/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

public abstract class SparseVectorIndexMap {
    protected int lastRequestedIndex = -1;
    protected int lastRequestedPosition = -1;
    protected int size;
    private static double GROWTH_FACTOR = 2.0;
    protected int[] nonZeroIndices;
    protected int usedNonZero;

    SparseVectorIndexMap(int _size) {
        this.size = _size;
        this.usedNonZero = 0;
        this.nonZeroIndices = new int[0];
    }

    SparseVectorIndexMap(SparseVectorIndexMap base) {
        this.size = base.size;
        this.usedNonZero = base.usedNonZero;
        this.nonZeroIndices = new int[this.usedNonZero];
        System.arraycopy(base.nonZeroIndices, 0, this.nonZeroIndices, 0, this.usedNonZero);
    }

    private int getPosWhereValueEqualKey(int value, int left, int right) {
        --right;
        while (left <= right) {
            int middle = left + (right - left) / 2;
            int valueAtMiddle = this.nonZeroIndices[middle];
            if (valueAtMiddle < value) {
                left = middle + 1;
                continue;
            }
            if (valueAtMiddle > value) {
                right = middle - 1;
                continue;
            }
            return middle;
        }
        return -1;
    }

    private int getPosWhereValueGreaterEqualKey(int value, int left, int right) {
        if (left == right) {
            return right;
        }
        int middle = left + (--right - left) / 2;
        while (left <= right) {
            middle = left + (right - left) / 2;
            int valueAtMiddle = this.nonZeroIndices[middle];
            if (valueAtMiddle < value) {
                left = middle + 1;
                continue;
            }
            if (valueAtMiddle > value) {
                right = middle - 1;
                continue;
            }
            return middle;
        }
        if (this.nonZeroIndices[middle] >= value) {
            return middle;
        }
        return middle + 1;
    }

    protected int addIndex(int index) {
        int pos = this.getPosWhereValueGreaterEqualKey(index, 0, this.usedNonZero);
        if (pos < this.usedNonZero && this.nonZeroIndices[pos] == index) {
            this.lastRequestedPosition = pos;
            return pos;
        }
        this.createRoomAt(pos);
        this.nonZeroIndices[pos] = index;
        this.lastRequestedPosition = pos;
        return pos;
    }

    protected void removeIndex(int index) {
        int pos = this.getPosWhereValueEqualKey(index, 0, this.usedNonZero);
        if (pos >= 0) {
            this.killRoomAt(pos);
        }
    }

    protected int getPosition(int index) {
        int pos;
        if (index == this.lastRequestedIndex) {
            return this.lastRequestedPosition;
        }
        this.lastRequestedIndex = index;
        this.lastRequestedPosition = pos = this.getPosWhereValueEqualKey(index, 0, this.usedNonZero);
        return pos;
    }

    private void createRoomAt(int pos) {
        int currentLength = this.nonZeroIndices.length;
        int firstBlockLength = pos;
        int secondBlockLength = this.usedNonZero - pos;
        ++this.usedNonZero;
        if (this.usedNonZero > currentLength) {
            int newLength = 1;
            if (currentLength > 0) {
                newLength = (int)((double)currentLength * GROWTH_FACTOR);
            }
            this.augmentNonZero(newLength, firstBlockLength, secondBlockLength);
            this.augmentData(newLength, firstBlockLength, secondBlockLength);
        } else {
            this.shiftNonZeroRight(firstBlockLength, secondBlockLength);
            this.shiftDataRight(firstBlockLength, secondBlockLength);
        }
    }

    private void killRoomAt(int pos) {
        --this.usedNonZero;
        int firstBlockLength = pos;
        int secondBlockLength = this.usedNonZero - pos;
        this.shiftNonZeroLeft(firstBlockLength, secondBlockLength);
        this.shiftDataLeft(firstBlockLength, secondBlockLength);
    }

    protected abstract void augmentData(int var1, int var2, int var3);

    private void augmentNonZero(int newLength, int firstBlockLength, int secondBlockLength) {
        int[] newNonZeroIndices = new int[newLength];
        System.arraycopy(this.nonZeroIndices, 0, newNonZeroIndices, 0, firstBlockLength);
        System.arraycopy(this.nonZeroIndices, firstBlockLength, newNonZeroIndices, firstBlockLength + 1, secondBlockLength);
        this.nonZeroIndices = newNonZeroIndices;
    }

    protected abstract void shiftDataRight(int var1, int var2);

    private void shiftNonZeroRight(int firstBlockLength, int secondBlockLength) {
        System.arraycopy(this.nonZeroIndices, firstBlockLength, this.nonZeroIndices, firstBlockLength + 1, secondBlockLength);
    }

    protected abstract void shiftDataLeft(int var1, int var2);

    private void shiftNonZeroLeft(int firstBlockLength, int secondBlockLength) {
        System.arraycopy(this.nonZeroIndices, firstBlockLength + 1, this.nonZeroIndices, firstBlockLength, secondBlockLength);
    }

    private void test() {
        this.nonZeroIndices = new int[]{1, 4, 5, 7};
        this.usedNonZero = 4;
        this.size = 8;
        System.out.println("exp: 1 + findIndexEqualKey(4): " + this.getPosWhereValueEqualKey(4, 0, this.usedNonZero));
        System.out.println("exp:-1 + findIndexEqualKey(6): " + this.getPosWhereValueEqualKey(6, 0, this.usedNonZero));
        System.out.println("exp: 0 + findIndexGreaterOrEqualKey(0): " + this.getPosWhereValueGreaterEqualKey(0, 0, this.usedNonZero));
        System.out.println("exp: 0 + findIndexGreaterOrEqualKey(1): " + this.getPosWhereValueGreaterEqualKey(1, 0, this.usedNonZero));
        System.out.println("exp: 1 + findIndexGreaterOrEqualKey(2): " + this.getPosWhereValueGreaterEqualKey(2, 0, this.usedNonZero));
        System.out.println("exp: 1 + findIndexGreaterOrEqualKey(3): " + this.getPosWhereValueGreaterEqualKey(3, 0, this.usedNonZero));
        System.out.println("exp: 1 + findIndexGreaterOrEqualKey(4): " + this.getPosWhereValueGreaterEqualKey(4, 0, this.usedNonZero));
        System.out.println("exp: 2 + findIndexGreaterOrEqualKey(5): " + this.getPosWhereValueGreaterEqualKey(5, 0, this.usedNonZero));
        System.out.println("exp: 3 + findIndexGreaterOrEqualKey(6): " + this.getPosWhereValueGreaterEqualKey(6, 0, this.usedNonZero));
        System.out.println("exp: 3 + findIndexGreaterOrEqualKey(7): " + this.getPosWhereValueGreaterEqualKey(7, 0, this.usedNonZero));
    }

    public static String toString(int[] arr, String del) {
        if (arr == null) {
            return "null";
        }
        if (arr.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(arr.length * 10);
        int i = 0;
        while (i < arr.length) {
            out.append(String.valueOf(arr[i]));
            if (i + 1 < arr.length) {
                out.append(del);
            }
            ++i;
        }
        return out.toString();
    }

    public static String toString(double[] arr, String del) {
        if (arr == null) {
            return "null";
        }
        if (arr.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(arr.length * 10);
        int i = 0;
        while (i < arr.length) {
            out.append(String.valueOf(arr[i]));
            if (i + 1 < arr.length) {
                out.append(del);
            }
            ++i;
        }
        return out.toString();
    }
}

