/*
 * Decompiled with CFR 0.152.
 */
package stallone.dynamics;

import stallone.api.doubles.IDoubleArray;
import stallone.api.dynamics.IIntegrator;
import stallone.api.potential.IEnergyModel;

public class VelocityVerlet
implements IIntegrator {
    private IEnergyModel model;
    private double dt;
    private IDoubleArray x;
    private IDoubleArray v;
    private IDoubleArray a;
    private IDoubleArray masses;

    public VelocityVerlet(double _dt) {
        this.dt = _dt;
    }

    @Override
    public IIntegrator copy() {
        VelocityVerlet res = new VelocityVerlet(this.dt);
        res.setEnergyModel(this.model);
        res.setMasses(this.masses.copy());
        res.setX(this.x.copy());
        res.setV(this.v.copy());
        return res;
    }

    @Override
    public void setX(IDoubleArray x0) {
        this.x = x0;
    }

    @Override
    public void setV(IDoubleArray v0) {
        this.v = v0;
    }

    @Override
    public void setEnergyModel(IEnergyModel _model) {
        this.model = _model;
        this.a = this.v.copy();
    }

    @Override
    public void setMasses(IDoubleArray _masses) {
        this.masses = _masses;
    }

    @Override
    public void setStepLength(double _dt) {
        this.dt = _dt;
    }

    @Override
    public boolean step() {
        int i = 0;
        while (i < this.x.size()) {
            this.x.set(i, this.x.get(i) + this.dt * this.v.get(i) + 0.5 * this.dt * this.dt * this.a.get(i));
            this.v.set(i, this.v.get(i) + 0.5 * this.dt * this.a.get(i));
            ++i;
        }
        this.model.setCoordinates(this.x);
        boolean success = this.model.calculate();
        if (!success) {
            return false;
        }
        IDoubleArray gradient = this.model.getGradient();
        int i2 = 0;
        while (i2 < this.x.size()) {
            this.a.set(i2, -gradient.get(i2) / this.masses.get(i2));
            this.v.set(i2, this.v.get(i2) + 0.5 * this.dt * this.a.get(i2));
            ++i2;
        }
        return true;
    }

    @Override
    public IDoubleArray getX() {
        return this.x;
    }

    @Override
    public IDoubleArray getV() {
        return this.v;
    }

    @Override
    public IDoubleArray getA() {
        return this.a;
    }

    @Override
    public double potentialEnergy() {
        return this.model.getEnergy();
    }

    @Override
    public double kineticEnergy() {
        double ekin = 0.0;
        int i = 0;
        while (i < this.masses.size()) {
            ekin += 0.5 * this.masses.get(i) * this.v.get(i) * this.v.get(i);
            ++i;
        }
        return ekin;
    }

    @Override
    public double totalEnergy() {
        return this.model.getEnergy() + this.kineticEnergy();
    }

    @Override
    public double getStepLength() {
        return this.dt;
    }
}

