/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm;

import stallone.api.hmm.ParameterEstimationException;
import stallone.doubles.PrimitiveDoubleTools;
import stallone.hmm.HMMForwardModel;
import stallone.hmm.HMMHiddenVariables;

public class ForwardBackward {
    private HMMForwardModel model;

    public ForwardBackward(HMMForwardModel _model) {
        this.model = _model;
    }

    public void computePath(int itraj, HMMHiddenVariables hidden) throws ParameterEstimationException {
        int t = 0;
        while (t < hidden.size()) {
            int j = 0;
            while (j < this.model.getNStates()) {
                hidden.setPout(t, j, this.model.getPout(itraj, t, j));
                ++j;
            }
            if (!hidden.checkPout(t)) {
                throw new ParameterEstimationException(" \n\n======== Parameter Estimation Exception ========\nAt trajectory " + itraj + ", timestep " + t + "\n" + "Observation = " + this.model.getObs(itraj, t) + "\n\n" + "HMM parameters: \n" + this.model.getParameters() + "\n" + "pout = " + PrimitiveDoubleTools.toString(hidden.getPout(t), "\t") + "\n" + "cannot normalize pout. Check IHMMModel implementation.\n" + "================================================ \n");
            }
            ++t;
        }
        int j = 0;
        while (j < this.model.getNStates()) {
            hidden.setAlpha(0, j, this.model.getP0(itraj, j) * hidden.getPout(0, j));
            ++j;
        }
        try {
            hidden.normalizeAlpha(0);
        }
        catch (RuntimeException e) {
            System.out.println("CAUGHT: " + e);
            System.out.println(" pout = " + PrimitiveDoubleTools.toString(hidden.getPout(0), "\t"));
        }
        t = 1;
        while (t < hidden.size()) {
            int j2 = 0;
            while (j2 < this.model.getNStates()) {
                hidden.setAlpha(t, j2, 0.0);
                int i = 0;
                while (i < this.model.getNStates()) {
                    hidden.addAlpha(t, j2, hidden.getAlpha(t - 1, i) * this.model.getPtrans(itraj, t - 1, i, j2) * hidden.getPout(t, j2));
                    ++i;
                }
                ++j2;
            }
            try {
                hidden.normalizeAlpha(t);
            }
            catch (RuntimeException e) {
                System.out.println("CAUGHT: " + e);
                System.out.println(" pout = " + PrimitiveDoubleTools.toString(hidden.getPout(0), "\t"));
            }
            ++t;
        }
        int i = 0;
        while (i < this.model.getNStates()) {
            hidden.setBeta(hidden.size() - 1, i, 1.0 / (double)this.model.getNStates());
            ++i;
        }
        hidden.normalizeBeta(hidden.size() - 1);
        t = hidden.size() - 2;
        while (t >= 0) {
            int i2 = 0;
            while (i2 < this.model.getNStates()) {
                hidden.setBeta(t, i2, 0.0);
                int j3 = 0;
                while (j3 < this.model.getNStates()) {
                    hidden.addBeta(t, i2, hidden.getBeta(t + 1, j3) * this.model.getPtrans(itraj, t, i2, j3) * hidden.getPout(t + 1, j3));
                    ++j3;
                }
                ++i2;
            }
            hidden.normalizeBeta(t);
            --t;
        }
        hidden.updateGamma();
    }
}

