/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm;

import java.util.List;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.api.function.IParametricFunction;
import stallone.api.hmm.IHMMParameters;
import stallone.api.mc.ITransitionMatrixEstimator;
import stallone.api.mc.MarkovModel;
import stallone.hmm.IHMMForwardModel;
import stallone.hmm.MatrixPowerCache;

public class HMMForwardModel
implements IHMMForwardModel {
    private List<IDataSequence> obs;
    private int nstates;
    private boolean eventBased = false;
    private IHMMParameters par;
    private IParametricFunction[] fOut;
    private ITransitionMatrixEstimator Testimator;
    private MatrixPowerCache matrixPower;

    public HMMForwardModel(List<IDataSequence> _obs, boolean _eventBased, int _nstates, boolean reversible, IParametricFunction _fOut) {
        this.obs = _obs;
        this.nstates = _nstates;
        this.eventBased = _eventBased;
        this.fOut = new IParametricFunction[this.nstates];
        int i = 0;
        while (i < this.fOut.length) {
            this.fOut[i] = (IParametricFunction)_fOut.copy();
            ++i;
        }
        if (this.eventBased) {
            int dtmax = 1;
            for (IDataSequence seq : this.obs) {
                int i2 = 0;
                while (i2 < seq.size() - 1) {
                    int dt = (int)Math.round(seq.getTime(i2 + 1) - seq.getTime(i2));
                    if (dt > dtmax) {
                        dtmax = dt;
                    }
                    ++i2;
                }
            }
            if (dtmax > 1000) {
                dtmax = 1000;
            }
            this.matrixPower = new MatrixPowerCache(dtmax);
        }
        this.Testimator = reversible ? MarkovModel.create.createTransitionMatrixEstimatorRev() : MarkovModel.create.createTransitionMatrixEstimatorNonrev();
    }

    public void setParameters(IHMMParameters _par) {
        this.par = _par;
        int i = 0;
        while (i < this.fOut.length) {
            this.fOut[i].setParameters(_par.getOutputParameters(i));
            ++i;
        }
    }

    public HMMForwardModel copy() {
        HMMForwardModel res = new HMMForwardModel(this.obs, this.eventBased, this.fOut.length, this.par.isReversible(), this.fOut[0]);
        res.setParameters(this.par);
        return res;
    }

    @Override
    public int getNStates() {
        return this.nstates;
    }

    @Override
    public int getNObs() {
        return this.obs.size();
    }

    @Override
    public int getNObs(int traj) {
        return this.obs.get(traj).size();
    }

    public boolean isEventBased() {
        return this.eventBased;
    }

    @Override
    public double getP0(int traj, int state) {
        return this.par.getInitialDistribution().get(state);
    }

    @Override
    public double getPtrans(int traj, int timeindex1, int state1, int state2) {
        if (!this.eventBased) {
            return this.par.getTransitionMatrix().get(state1, state2);
        }
        IDataSequence seq = this.obs.get(traj);
        int dt = (int)(seq.getTime(timeindex1 + 1) - seq.getTime(timeindex1));
        return this.matrixPower.getPowerElement(this.par.getTransitionMatrix(), dt, state1, state2);
    }

    @Override
    public double getPout(int traj, int timeindex, int state) {
        IDoubleArray x = this.obs.get(traj).get(timeindex);
        return this.fOut[state].f(x);
    }

    public IDoubleArray getObs(int traj, int timeindex) {
        IDoubleArray x = this.obs.get(traj).get(timeindex);
        return x;
    }

    @Override
    public void setTransitionCounts(IDoubleArray C) {
        this.Testimator.setCounts(C);
        this.Testimator.estimate();
        IDoubleArray T = this.Testimator.getTransitionMatrix();
        this.par.setTransitionMatrix(T);
    }

    @Override
    public void setOutputParameters(int state, IDoubleArray parOut) {
        this.par.setOutputParameters(state, parOut);
        this.fOut[state].setParameters(parOut);
    }

    @Override
    public IHMMParameters getParameters() {
        return this.par;
    }
}

