/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm;

import java.util.ArrayList;
import java.util.List;
import stallone.api.API;
import stallone.api.ints.IIntArray;
import stallone.doubles.PrimitiveDoubleTools;
import stallone.hmm.IHMMForwardModel;

public class Viterbi {
    private IHMMForwardModel forwardModel;
    private ArrayList<IIntArray> paths = new ArrayList();

    public Viterbi(IHMMForwardModel _forwardModel) {
        this.forwardModel = _forwardModel;
        int i = 0;
        while (i < _forwardModel.getNObs()) {
            this.paths.add(this.calculate(i));
            ++i;
        }
    }

    private IIntArray calculate(int itraj) {
        int ntime = this.forwardModel.getNObs(itraj);
        int nstates = this.forwardModel.getNStates();
        double[][] T1 = new double[ntime][nstates];
        int[][] ptr = new int[ntime][nstates];
        int s = 0;
        while (s < nstates) {
            T1[0][s] = this.forwardModel.getP0(itraj, s) * this.forwardModel.getPout(itraj, 0, s);
            ++s;
        }
        int t = 1;
        while (t < ntime) {
            int s2 = 0;
            while (s2 < nstates) {
                double pmax = 0.0;
                int kmax = 0;
                int k = 0;
                while (k < nstates) {
                    double p = T1[t - 1][k] * this.forwardModel.getPtrans(itraj, t - 1, k, s2);
                    if (p > pmax) {
                        pmax = p;
                        kmax = k;
                    }
                    ++k;
                }
                T1[t][s2] = pmax * this.forwardModel.getPout(itraj, t, s2);
                ptr[t][s2] = kmax;
                ++s2;
            }
            T1[t] = PrimitiveDoubleTools.multiply(1.0 / PrimitiveDoubleTools.sum(T1[t]), T1[t]);
            ++t;
        }
        IIntArray path = API.intsNew.array(ntime);
        path.set(ntime - 1, PrimitiveDoubleTools.maxIndex(T1[ntime - 1]));
        int t2 = ntime - 2;
        while (t2 >= 0) {
            path.set(t2, ptr[t2 + 1][path.get(t2 + 1)]);
            --t2;
        }
        return path;
    }

    public IIntArray getPath(int i) {
        return this.paths.get(i);
    }

    public List<IIntArray> getPaths() {
        return this.paths;
    }
}

