/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm.pmm;

import java.io.FileNotFoundException;
import java.io.IOException;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.ints.PrimitiveIntTools;
import stallone.util.CommandLineParser;

public class AssignEigenvectorsCmd {
    private String inDir;
    private int reflag;
    private double minOverlap;
    private IDoubleArray pibig0;
    private IDoubleArray Rbig0;

    public boolean parseArguments(String[] args) throws FileNotFoundException, IOException {
        CommandLineParser parser = new CommandLineParser();
        parser.addStringCommand("i", true);
        parser.addIntCommand("reflag", true);
        parser.addDoubleCommand("minoverlap", true);
        if (!parser.parse(args)) {
            return false;
        }
        this.inDir = parser.getString("i");
        this.reflag = parser.getInt("reflag");
        this.minOverlap = parser.getDouble("minoverlap");
        return true;
    }

    public void setReference(IDoubleArray _pibig0, IDoubleArray _Rbig0) {
        this.pibig0 = _pibig0;
        this.Rbig0 = _Rbig0;
    }

    public double overlap(IDoubleArray ri, int iref, IDoubleArray pibig) {
        IDoubleArray ri0 = this.Rbig0.viewColumn(iref);
        API.alg.scale(1.0 / Math.sqrt(API.alg.dot(ri0, ri0, this.pibig0)), ri0);
        API.alg.scale(1.0 / Math.sqrt(API.alg.dot(ri, ri, pibig)), ri);
        IDoubleArray pisym = this.pibig0.copy();
        int i = 0;
        while (i < pisym.size()) {
            pisym.set(i, Math.sqrt(this.pibig0.get(i) * pibig.get(i)));
            ++i;
        }
        return Math.abs(API.alg.dot(ri0, ri, pisym));
    }

    public static String getUsageString() {
        return "\n=======================================\n AssignEigenvectorsCmd\n=======================================\nUsage: \n\nMandatory input and output options: \n -i <input-directory>+\n\n -reflag <reference-lagtime>\n -minoverlap <minimum-overlap>\n";
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        AssignEigenvectorsCmd cmd;
        if (args.length == 0) {
            System.out.println(AssignEigenvectorsCmd.getUsageString());
            System.exit(0);
        }
        if (!(cmd = new AssignEigenvectorsCmd()).parseArguments(args)) {
            System.out.println(AssignEigenvectorsCmd.getUsageString());
            System.exit(0);
        }
        IDoubleArray lagFile = API.doublesNew.fromFile(String.valueOf(cmd.inDir) + "/hmm-its.dat");
        int[] lagtimes = PrimitiveIntTools.from(lagFile.getColumn(0));
        IDoubleArray pibig0 = API.doublesNew.fromFile(String.valueOf(cmd.inDir) + "/hmm-pibig-lag" + cmd.reflag + ".dat");
        IDoubleArray Rbig0 = API.doublesNew.fromFile(String.valueOf(cmd.inDir) + "/hmm-Rbig-lag" + cmd.reflag + ".dat");
        cmd.setReference(pibig0, Rbig0);
        int[] nArray = lagtimes;
        int n = lagtimes.length;
        int n2 = 0;
        while (n2 < n) {
            int tau = nArray[n2];
            IDoubleArray TC = API.doublesNew.fromFile(String.valueOf(cmd.inDir) + "/hmm-TC-lag" + tau + ".dat");
            IDoubleArray timescales = API.msm.timescales(TC, tau);
            IDoubleArray pibig = API.doublesNew.fromFile(String.valueOf(cmd.inDir) + "/hmm-pibig-lag" + tau + ".dat");
            IDoubleArray Rbig = API.doublesNew.fromFile(String.valueOf(cmd.inDir) + "/hmm-Rbig-lag" + tau + ".dat");
            System.out.print(String.valueOf(tau) + "\t");
            int i = 1;
            while (i < Rbig.columns()) {
                IDoubleArray ri = Rbig.viewColumn(i);
                double max = 0.0;
                int argmax = i;
                int j = 1;
                while (j < Rbig.columns()) {
                    double o = cmd.overlap(ri, j, pibig);
                    if (o > max) {
                        max = o;
                        argmax = j;
                    }
                    ++j;
                }
                if (max > cmd.minOverlap) {
                    System.out.print(String.valueOf(timescales.get(argmax - 1)) + "\t");
                } else {
                    System.out.print("0\t");
                }
                ++i;
            }
            System.out.println();
            ++n2;
        }
    }
}

