/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm.pmm;

import java.util.ArrayList;
import java.util.List;
import stallone.api.API;
import stallone.api.cluster.IClustering;
import stallone.api.datasequence.IDataSequence;
import stallone.api.discretization.IDiscretization;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.datasequence.DataSequenceSubset;
import stallone.ints.PrimitiveIntTools;

public class MultiClusteringSplitMerge {
    private IDataSequence data;
    private IMetric metric;
    private IClustering clusterMethodLeaves;
    private IIntArray micro2macro;
    private ArrayList<Leaf> leaves = new ArrayList();
    private IIntArray micro2macroNew;
    private ArrayList<Leaf> leavesNew = new ArrayList();

    public MultiClusteringSplitMerge(IDataSequence _data, IClustering _clusterMethodFull, IClustering _clusterMethodLeaves) {
        this.data = _data;
        this.clusterMethodLeaves = _clusterMethodLeaves;
        _clusterMethodFull.setInput(_data);
        _clusterMethodFull.perform();
        IDataSequence centers = _clusterMethodFull.getClusterCenters();
        IDiscretization assignment = _clusterMethodFull.getClusterAssignment();
        this.micro2macro = API.cluster.discretize(this.data, assignment);
        int nClusters = _clusterMethodFull.getNumberOfClusters();
        int i = 0;
        while (i < nClusters) {
            IDoubleArray leafCenter = centers.get(i);
            IIntList leafIndexes = API.ints.findAll(this.micro2macro, i);
            this.leaves.add(new Leaf(leafIndexes));
            ++i;
        }
    }

    public MultiClusteringSplitMerge(IDataSequence _data, IDataSequence _initcenters, IMetric _metric, IClustering _clusterMethodLeaves) {
        this.data = _data;
        this.clusterMethodLeaves = _clusterMethodLeaves;
        this.metric = _metric;
        IDiscretization voronoiDiscretization = API.discNew.voronoiDiscretization(_initcenters, _metric);
        this.micro2macro = API.cluster.discretize(_data, voronoiDiscretization);
        int nInitialClusters = _initcenters.size();
        IIntList[] leafIndexes = new IIntList[nInitialClusters];
        int i = 0;
        while (i < leafIndexes.length) {
            leafIndexes[i] = API.intsNew.list(0);
            ++i;
        }
        i = 0;
        while (i < this.micro2macro.size()) {
            int s = this.micro2macro.get(i);
            leafIndexes[s].append(i);
            ++i;
        }
        i = 0;
        while (i < leafIndexes.length) {
            this.leaves.add(new Leaf(leafIndexes[i]));
            ++i;
        }
    }

    private boolean split(int leafIndex) {
        int nClustersBeforeSplitting = this.leavesNew.size();
        Leaf leaf = this.leavesNew.get(leafIndex);
        DataSequenceSubset subset = new DataSequenceSubset(this.data, leaf.indexes);
        this.clusterMethodLeaves.setInput(subset);
        this.clusterMethodLeaves.perform();
        int nPieces = this.clusterMethodLeaves.getNumberOfClusters();
        if (nPieces == 1) {
            return false;
        }
        int[] reassign = new int[this.clusterMethodLeaves.getNumberOfClusters()];
        reassign[0] = leafIndex;
        int i = 1;
        while (i < reassign.length) {
            reassign[i] = nClustersBeforeSplitting + (i - 1);
            ++i;
        }
        IDiscretization assignment = this.clusterMethodLeaves.getClusterAssignment();
        IDataSequence centers = this.clusterMethodLeaves.getClusterCenters();
        IIntArray micro2macroLeaf = API.cluster.discretize(subset, assignment);
        int i2 = 0;
        while (i2 < leaf.indexes.size()) {
            int globalIndex = leaf.indexes.get(i2);
            int newClusterIndex = reassign[micro2macroLeaf.get(i2)];
            this.micro2macroNew.set(globalIndex, newClusterIndex);
            ++i2;
        }
        IIntArray[] newLeaveIndexes = new IIntArray[nPieces];
        int i3 = 0;
        while (i3 < nPieces) {
            newLeaveIndexes[i3] = API.ints.findAll(micro2macroLeaf, i3);
            int j = 0;
            while (j < newLeaveIndexes[i3].size()) {
                newLeaveIndexes[i3].set(j, leaf.indexes.get(newLeaveIndexes[i3].get(j)));
                ++j;
            }
            ++i3;
        }
        this.leavesNew.set(leafIndex, new Leaf(newLeaveIndexes[0]));
        i3 = 1;
        while (i3 < nPieces) {
            this.leavesNew.add(new Leaf(newLeaveIndexes[i3]));
            ++i3;
        }
        System.out.print(" splitted indexes: " + leafIndex + " -> (" + PrimitiveIntTools.toString(reassign, ",") + ")" + "\n  nstates: " + leaf.indexes.size() + " -> (");
        i3 = 0;
        while (i3 < newLeaveIndexes.length) {
            System.out.print(String.valueOf(newLeaveIndexes[i3].size()) + ",");
            ++i3;
        }
        System.out.println(")\n  now we have " + this.leavesNew.size() + " states");
        return true;
    }

    public boolean considerSplit(IIntArray leafIndexes) {
        this.micro2macroNew = this.micro2macro.copy();
        this.leavesNew = (ArrayList)this.leaves.clone();
        boolean couldsplit = false;
        IIntArray I = API.ints.sortedIndexes(leafIndexes);
        int i = I.size() - 1;
        while (i >= 0) {
            int splitIndex = leafIndexes.get(I.get(i));
            if (this.split(splitIndex)) {
                couldsplit = true;
            }
            --i;
        }
        return couldsplit;
    }

    private void merge(List<Leaf> leavesToMerge) {
        IIntList mergedIndexes = API.intsNew.list(0);
        for (Leaf l : leavesToMerge) {
            mergedIndexes.appendAll(l.indexes);
        }
        Leaf newLeaf = new Leaf(mergedIndexes);
        this.leavesNew.removeAll(leavesToMerge);
        this.leavesNew.add(newLeaf);
        int s = 0;
        while (s < this.leavesNew.size()) {
            IIntArray I = this.leavesNew.get((int)s).indexes;
            int i = 0;
            while (i < I.size()) {
                this.micro2macroNew.set(I.get(i), s);
                ++i;
            }
            ++s;
        }
    }

    public void considerMerge(List<IIntArray> mergeGroups) {
        this.micro2macroNew = this.micro2macro.copy();
        this.leavesNew = (ArrayList)this.leaves.clone();
        ArrayList allLeavesToMerge = new ArrayList();
        for (IIntArray mergeGroup : mergeGroups) {
            ArrayList<Leaf> leavesToMerge = new ArrayList<Leaf>();
            int i = 0;
            while (i < mergeGroup.size()) {
                Leaf l = this.leavesNew.get(mergeGroup.get(i));
                leavesToMerge.add(l);
                ++i;
            }
            allLeavesToMerge.add(leavesToMerge);
        }
        int i = 0;
        while (i < allLeavesToMerge.size()) {
            this.merge((List)allLeavesToMerge.get(i));
            ++i;
        }
    }

    public ArrayList<IIntArray> getCurrentLeafIndexes() {
        ArrayList<IIntArray> res = new ArrayList<IIntArray>();
        for (Leaf l : this.leaves) {
            res.add(l.indexes);
        }
        return res;
    }

    public ArrayList<IIntArray> getNewLeafIndexes() {
        ArrayList<IIntArray> res = new ArrayList<IIntArray>();
        for (Leaf l : this.leavesNew) {
            res.add(l.indexes);
        }
        return res;
    }

    public IIntArray getCurrentDiscreteTrajectory() {
        return this.micro2macro;
    }

    public IIntArray getNewDiscreteTrajectory() {
        return this.micro2macroNew;
    }

    public void accept() {
        if (this.micro2macroNew == null) {
            return;
        }
        this.micro2macro = this.micro2macroNew;
        this.leaves = this.leavesNew;
    }

    class Leaf {
        public IIntArray indexes;

        public Leaf(IIntArray _indexes) {
            this.indexes = _indexes;
        }
    }
}

